/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.dump;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.qubership.profiler.dump.EOFInputStream;

public class FilesEnumeration
implements Enumeration<InputStream> {
    Iterator<File> it;
    File currentFile;

    public FilesEnumeration(Iterator<File> it) {
        this.it = it;
    }

    @Override
    public boolean hasMoreElements() {
        return this.it.hasNext();
    }

    @Override
    public InputStream nextElement() {
        try {
            this.currentFile = this.it.next();
            return FilesEnumeration.openInputStream(this.currentFile);
        }
        catch (EOFException e) {
            return new EOFInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long currentFileLenght() {
        return this.currentFile.length();
    }

    private static InputStream openInputStream(File file) throws IOException {
        boolean isGzip = file.getName().endsWith(".gz");
        try {
            return new BufferedInputStream(new GZIPInputStream((InputStream)new FileInputStream(file.getAbsolutePath() + (isGzip ? "" : ".gz")), 131072), 131072);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String fileName = file.getAbsolutePath();
            if (isGzip) {
                fileName = fileName.substring(0, fileName.length() - 2);
            }
            return new BufferedInputStream(new FileInputStream(fileName), 131072);
        }
    }
}

