/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.fetch;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.qubership.profiler.analyzer.AggregateJFRStacks;
import org.qubership.profiler.analyzer.MergeTrees;
import org.qubership.profiler.dom.ProfiledTreeStreamVisitor;
import org.qubership.profiler.fetch.StackcollapseParser;
import org.qubership.profiler.io.FileWalker;
import org.qubership.profiler.io.InputStreamProcessor;
import org.qubership.profiler.io.LimitedInputStreamProcessor;
import org.qubership.profiler.io.exceptions.ErrorSupervisor;
import org.qubership.profiler.output.CallTreeMediator;
import org.qubership.profiler.sax.stack.DumpsVisitor;

public class FetchStackcollapse
implements Runnable {
    private final ProfiledTreeStreamVisitor sv;
    private final String dumpsFile;
    private final long firstByte;
    private final long lastByte;

    public FetchStackcollapse(CallTreeMediator mediator, String dumpsFile, long firstByte, long lastByte) {
        this.sv = mediator;
        this.dumpsFile = dumpsFile;
        this.firstByte = firstByte;
        this.lastByte = lastByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DumpsVisitor processChain = this.getDumpsProcessChain(this.sv);
        StackcollapseParser parser = new StackcollapseParser(processChain);
        AsyncProfilerRawProcessor process = new AsyncProfilerRawProcessor(parser);
        LimitedInputStreamProcessor out = new LimitedInputStreamProcessor(process, this.firstByte, this.lastByte);
        FileWalker walker = new FileWalker(out);
        try {
            walker.walk(this.dumpsFile);
        }
        catch (IOException e) {
            ErrorSupervisor.getInstance().warn("Error processing " + this.dumpsFile, e);
        }
        finally {
            processChain.visitEnd();
        }
    }

    private DumpsVisitor getDumpsProcessChain(ProfiledTreeStreamVisitor sv) {
        MergeTrees merge = new MergeTrees(sv);
        AggregateJFRStacks agg = new AggregateJFRStacks(merge);
        return agg;
    }

    static class AsyncProfilerRawProcessor
    implements InputStreamProcessor {
        private final StackcollapseParser parser;

        public AsyncProfilerRawProcessor(StackcollapseParser parser) {
            this.parser = parser;
        }

        @Override
        public boolean process(InputStream is, String name) {
            try {
                this.parser.parse(new InputStreamReader(is, "UTF-8"), name);
            }
            catch (UnsupportedEncodingException e) {
                ErrorSupervisor.getInstance().error("Java somehow does not support UTF-8", e);
            }
            return true;
        }
    }
}

