/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.fetch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.qubership.profiler.io.exceptions.ErrorSupervisor;
import org.qubership.profiler.sax.stack.DumpVisitor;
import org.qubership.profiler.sax.stack.DumpsVisitor;
import org.qubership.profiler.threaddump.parser.MethodThreadLineInfo;
import org.qubership.profiler.threaddump.parser.ThreadFormatParser;
import org.qubership.profiler.threaddump.parser.ThreadInfo;
import org.qubership.profiler.threaddump.parser.ThreaddumpParser;
import org.qubership.profiler.util.IOHelper;

public class StackcollapseParser
implements ThreadFormatParser {
    private final DumpsVisitor dumps;

    public StackcollapseParser(DumpsVisitor dumps) {
        this.dumps = dumps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Reader input, String name) {
        DumpVisitor dv = this.dumps.visitDump();
        BufferedReader br = IOHelper.ensureBuffered(input);
        String s = null;
        try {
            while ((s = br.readLine()) != null) {
                ThreadInfo thread = this.parseThread(s);
                dv.visitThread(thread);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (IOException e) {
            ErrorSupervisor.getInstance().warn("Error while parsing stackcollapse dump " + name + " at line " + s, e);
        }
        finally {
            dv.visitEnd();
        }
    }

    @Override
    public ThreadInfo parseThread(String s) {
        String[] methods = s.split(";");
        String lastMethod = methods[methods.length - 1];
        int lastSpace = lastMethod.lastIndexOf(32);
        int count = 1;
        if (lastSpace != -1) {
            methods[methods.length - 1] = lastMethod.substring(0, lastSpace);
            count = Integer.parseInt(lastMethod.substring(lastSpace + 1));
        }
        ThreadInfo thread = new ThreadInfo();
        thread.value = count;
        for (int i = methods.length - 1; i >= 0; --i) {
            String method = methods[i];
            ThreaddumpParser.ThreadLineInfo frame = this.parseThreadLine(method);
            thread.addThreadLine(frame);
        }
        return thread;
    }

    @Override
    public ThreaddumpParser.ThreadLineInfo parseThreadLine(String method) {
        int doubleColon;
        MethodThreadLineInfo frame = new MethodThreadLineInfo();
        int lastDot = method.indexOf(46);
        if (lastDot != -1) {
            frame.methodName = method.substring(lastDot + 1);
            frame.className = method.substring(0, lastDot).replace('/', '.');
            frame.locationClass = "Unknown";
            return frame;
        }
        int argStart = method.indexOf(40);
        if (argStart != -1) {
            int argEnd = method.lastIndexOf(41);
            if (argEnd == -1) {
                argEnd = method.length();
            }
            frame.arguments = method.substring(argStart + 1, argEnd);
            method = method.substring(0, argStart);
        }
        String libName = null;
        int doubleAt = method.indexOf("@@");
        if (doubleAt != -1) {
            libName = method.substring(doubleAt + 2).replace('.', '_');
            method = method.substring(0, doubleAt);
        }
        if ((doubleColon = method.indexOf("::")) != -1) {
            frame.className = method.substring(0, doubleColon);
            frame.methodName = method.substring(doubleColon + 2);
        } else {
            frame.methodName = method;
        }
        frame.methodName = frame.methodName.replace(" ", "");
        frame.className = StackcollapseParser.prependPackage(frame.className, libName);
        if (frame.methodName.endsWith("_[k]")) {
            frame.methodName = frame.methodName.substring(0, frame.methodName.length() - 4);
            frame.className = StackcollapseParser.prependPackage(frame.className, "kernel");
        }
        if (frame.className == null) {
            frame.className = "native";
        }
        return frame;
    }

    private static String prependPackage(String dst, String packageName) {
        if (dst == null || dst.length() == 0) {
            return packageName;
        }
        if (packageName == null || packageName.length() == 0) {
            return dst;
        }
        return packageName + "." + dst;
    }
}

