/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.formatters.title;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qubership.profiler.agent.ParameterInfo;
import org.qubership.profiler.formatters.title.AbstractTitleFormatter;
import org.qubership.profiler.formatters.title.OrchestratorTitleFormatter;
import org.qubership.profiler.formatters.title.ProfilerTitle;
import org.qubership.profiler.formatters.title.ProfilerTitleBuilder;
import org.qubership.profiler.formatters.title.TitleCommonTools;

public class JMSTitleFormatter
extends AbstractTitleFormatter {
    private Set<String> SKIP_PARAMS = Collections.EMPTY_SET;
    private OrchestratorTitleFormatter orchestratorFormatter = new OrchestratorTitleFormatter();

    @Override
    public ProfilerTitle formatTitle(String classMethod, Map<String, Integer> tagToIdMap, Object params, List<ParameterInfo> defaultListParams) {
        String consumer = TitleCommonTools.getParameter(tagToIdMap, params, "jms.consumer");
        if ("OrchestrationQueueInvokerBean".equals(consumer)) {
            return this.orchestratorFormatter.formatTitle(classMethod, tagToIdMap, params, defaultListParams);
        }
        ProfilerTitleBuilder title = new ProfilerTitleBuilder();
        title.append("JMS: ").appendHtml("<b>").append(consumer).appendHtml("</b>");
        TitleCommonTools.addGenericParams(title, tagToIdMap, params, defaultListParams, this.SKIP_PARAMS);
        TitleCommonTools.addParameter(title, tagToIdMap, params, ", destination: ", "jms.destination");
        TitleCommonTools.addParameter(title, tagToIdMap, params, ", text: ", "jms.text.fragment");
        return title;
    }

    @Override
    public ProfilerTitle formatCommonTitle(String classMethod, Map<String, Integer> tagToIdMap, Map<Integer, List<String>> params, Map<String, Object> formatContext) {
        ProfilerTitleBuilder title = new ProfilerTitleBuilder();
        String consumer = TitleCommonTools.getParameter(tagToIdMap, params, "jms.consumer");
        title.append("JMS: ").append(consumer);
        return title;
    }
}

