/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.formatters.title;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.profiler.agent.ParameterInfo;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.formatters.title.AbstractTitleFormatter;
import org.qubership.profiler.formatters.title.AutoInstallerTitleFormatter;
import org.qubership.profiler.formatters.title.BrockerTitleFormatter;
import org.qubership.profiler.formatters.title.DataFlowTitleFormatter;
import org.qubership.profiler.formatters.title.DefaultTitleFormatter;
import org.qubership.profiler.formatters.title.HttpTitleFormatter;
import org.qubership.profiler.formatters.title.ITitleFormatter;
import org.qubership.profiler.formatters.title.JMSTitleFormatter;
import org.qubership.profiler.formatters.title.ProfilerTitle;
import org.qubership.profiler.formatters.title.QuartzJobTitleFormatter;
import org.qubership.profiler.formatters.title.QuartzTriggerTitleFormatter;
import org.qubership.profiler.formatters.title.TitleCommonTools;
import org.qubership.profiler.shaded.gnu.trove.THashSet;
import org.qubership.profiler.shaded.gnu.trove.TIntObjectHashMap;

public class TitleFormatterFacade {
    private static final ITitleFormatter DEFAULT_FORMATTER = new DefaultTitleFormatter();
    private static Map<String, ITitleFormatter> formatters = new HashMap<String, ITitleFormatter>();
    private static List<ParameterInfo> sortedListParams = Collections.EMPTY_LIST;

    private static void initFormatters() {
        AbstractTitleFormatter formatter = new HttpTitleFormatter();
        formatters.put("NioEventLoop.runAllTasks", formatter);
        formatters.put("has.url", formatter);
        formatters.put("NioEventLoop.processSelectedKeys", formatter);
        formatters.put("SocketProcessorBase.run", formatter);
        formatters.put("TraceRunnable.run", formatter);
        formatters.put("WebAppServletContext$ServletInvocationAction.run", formatter);
        formatters.put("ServletRequestImpl.run", formatter);
        formatters.put("ServletRequestImpl.execute", formatter);
        formatters.put("StandardEngineValve.invoke", formatter);
        formatters.put("FilterHandler$FilterChainImpl.doFilter", formatter);
        formatters.put("Connectors.executeRootHandler", formatter);
        formatters.put("ServletHandler.doHandle", formatter);
        formatter = new QuartzTriggerTitleFormatter();
        formatters.put("NCJobStore.triggerFired", formatter);
        formatter = new QuartzJobTitleFormatter();
        formatters.put("JobRunShell.run", formatter);
        formatter = new JMSTitleFormatter();
        formatters.put("MDListener.run", formatter);
        formatters.put("MDListener.execute", formatter);
        formatters.put("MDListener.onMessage", formatter);
        formatters.put("JMSSession.onMessage", formatter);
        formatters.put("JMSSession$UseForRunnable.run", formatter);
        formatters.put("ClientConsumerImpl.callOnMessage", formatter);
        formatters.put("AbstractMessageListenerContainer.doExecuteListener", formatter);
        formatters.put("ActiveMQMessageHandler.onMessage", formatter);
        formatters.put("JMSMessageListenerWrapper.onMessage", formatter);
        formatter = new DataFlowTitleFormatter();
        formatters.put("DataFlowAwareRunnable.run", formatter);
        formatter = new AutoInstallerTitleFormatter();
        formatters.put("Main.runBuild", formatter);
        formatter = new BrockerTitleFormatter();
        formatters.put("MessagingMessageListenerAdapter", formatter);
    }

    public static void setDefaultListParams(List<ParameterInfo> defaultListParams) {
        Collections.sort(defaultListParams, new Comparator<ParameterInfo>(){

            @Override
            public int compare(ParameterInfo o1, ParameterInfo o2) {
                return Integer.compare(o1.order, o2.order);
            }
        });
        sortedListParams = defaultListParams;
    }

    public static ProfilerTitle formatTitle(int method, TIntObjectHashMap<THashSet<String>> params) {
        String classMethod = TitleFormatterFacade.asClassMethod(ProfilerData.resolveMethodId(method));
        ITitleFormatter formatter = TitleFormatterFacade.getFormatter(classMethod, null, params);
        try {
            return formatter.formatTitle(classMethod, params, sortedListParams);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in formatTile for " + classMethod + ", params: " + params, e);
        }
    }

    public static ProfilerTitle formatTitle(String fullClassMethod, Map<String, Integer> tagToIdMap, Map<Integer, List<String>> params) {
        String classMethod = TitleFormatterFacade.asClassMethod(fullClassMethod);
        if (params == null) {
            params = Collections.EMPTY_MAP;
        }
        ITitleFormatter formatter = TitleFormatterFacade.getFormatter(classMethod, tagToIdMap, params);
        try {
            return formatter.formatTitle(classMethod, tagToIdMap, params, sortedListParams);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in formatTile for " + classMethod + ", params: " + params, e);
        }
    }

    public static ProfilerTitle formatCommonTitle(String fullClassMethod, Map<String, Integer> tagToIdMap, Map<Integer, List<String>> params, Map<String, Object> formatContext) {
        String classMethod = TitleFormatterFacade.asClassMethod(fullClassMethod);
        if (params == null) {
            params = Collections.EMPTY_MAP;
        }
        ITitleFormatter formatter = TitleFormatterFacade.getFormatter(classMethod, tagToIdMap, params);
        try {
            return formatter.formatCommonTitle(classMethod, tagToIdMap, params, formatContext);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in formatTile for " + classMethod + ", params: " + params, e);
        }
    }

    private static ITitleFormatter getFormatter(String classMethod, Map<String, Integer> tagToIdMap, Object params) {
        ITitleFormatter formatter = formatters.get(classMethod);
        if (formatter != null) {
            return formatter;
        }
        Collection<String> webUrl = TitleCommonTools.getParameterValues(tagToIdMap, params, "web.url");
        Collection<String> queue = TitleCommonTools.getParameterValues(tagToIdMap, params, "queue");
        if (webUrl != null && !webUrl.isEmpty()) {
            return formatters.get("has.url");
        }
        if (queue != null && !queue.isEmpty()) {
            return formatters.get("MessagingMessageListenerAdapter");
        }
        return DEFAULT_FORMATTER;
    }

    private static String asClassMethod(String methodString) {
        int methodDotIndex;
        int braceIndex;
        int spaceIndex = methodString.indexOf(32);
        if (spaceIndex != -1 && (braceIndex = methodString.indexOf(40, spaceIndex + 1)) != -1 && (methodDotIndex = methodString.lastIndexOf(46, braceIndex)) != -1) {
            int lastClassDot = methodString.lastIndexOf(46, methodDotIndex - 1);
            return lastClassDot < spaceIndex ? methodString.substring(spaceIndex + 1, braceIndex) : methodString.substring(lastClassDot + 1, braceIndex);
        }
        return methodString;
    }

    static {
        TitleFormatterFacade.initFormatters();
    }
}

