/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.qubership.profiler.chart.StackedChart;
import org.qubership.profiler.chart.UnaryFunction;
import org.qubership.profiler.configuration.PropertyFacade;
import org.qubership.profiler.dom.ProfiledTree;
import org.qubership.profiler.dom.TagDictionary;
import org.qubership.profiler.io.Hotspot;
import org.qubership.profiler.io.HotspotTag;
import org.qubership.profiler.io.JSHelper;
import org.qubership.profiler.sax.values.StringValue;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;
import org.qubership.profiler.util.ThrowableHelper;
import org.qubership.profiler.util.TimeHelper;

public class ActiveSessionHistoryFetcher {
    public static final Logger log = LoggerFactory.getLogger(ActiveSessionHistoryFetcher.class);
    private final PrintWriter out;
    Set<String> sids;
    Collection<Throwable> exceptions;
    int oracleSidTagID;
    boolean oracleSidTagIsSidSerial = true;
    NumberFormat nf = NumberFormat.getInstance();
    NumberFormat nfTime = NumberFormat.getInstance();
    private static int idx = 1;
    public static final int COL_SQL_ID = idx++;
    public static final int COL_SQL_CHILD = idx++;
    public static final int COL_PLAN_HASH_VALUE = idx++;
    public static final int COL_COUNT = idx++;
    public static final int COL_DB_TIME = idx++;
    public static final int COL_DB_CPU_TIME = idx++;
    public static final int COL_SQL_TEXT = idx++;
    public static final int COL_SQL_PLANA = idx++;
    public static final int COL_SQL_PLANB = idx++;
    public static final int COL_READ_REQS = idx++;
    public static final int COL_WRITE_REQS = idx++;
    public static final int COL_READ_BYTES = idx++;
    public static final int COL_WRITE_BYTES = idx++;
    public static final int COL_PGA = idx++;
    public static final int COL_TEMP = idx++;
    public static final boolean AWR_DISABLED = Boolean.getBoolean("org.qubership.profiler.awr.disabled") || !Boolean.getBoolean("org.qubership.profiler.awr.enabled") && !System.getProperty("qubership.naming.provider.url", "").toLowerCase().contains(".qubership.org");
    private static final BigDecimal THOUSAND = BigDecimal.valueOf(1000L);
    private static final BigDecimal FIVE_THOUSAND = BigDecimal.valueOf(5000L);
    private static final String[] KILOS = new String[]{"&nbsp;", "K", "M", "G", "T"};
    private static final String[] KILO_BYTES = new String[]{"&nbsp;", "KB", "MB", "GB", "TB"};
    private static final String[] KILO_IOPS = new String[]{"&nbsp; IOs", "K IOs", "M IOs", "G IOs", "T IOs"};
    private static final BigDecimal X_1_000 = BigDecimal.valueOf(1000L);
    private static final BigDecimal X_10_0000 = BigDecimal.valueOf(100000L);
    private static final BigDecimal X_1_000_000 = BigDecimal.valueOf(1000000L);
    private static final BigDecimal X_10_000_000 = BigDecimal.valueOf(10000000L);
    private static final BigDecimal X_1_000_000_000 = BigDecimal.valueOf(1000000000L);
    private static final BigDecimal X_10_000_000_000 = BigDecimal.valueOf(10000000000L);

    public ActiveSessionHistoryFetcher(PrintWriter out) {
        this.out = out;
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
        this.nf.setMaximumIntegerDigits(4);
        this.nfTime.setMaximumFractionDigits(3);
        this.nfTime.setMinimumFractionDigits(3);
    }

    public void read(ProfiledTree agg) {
        int tagId;
        if (agg == null) {
            return;
        }
        TagDictionary dict = agg.getDict();
        ArrayList<String> tags = dict.getTags();
        int length = tags.size();
        for (tagId = 0; tagId < length && !"oracle.sid".equals(tags.get(tagId)); ++tagId) {
        }
        if (tagId == length) {
            for (tagId = 0; tagId < length && !"oracle.audsid".equals(tags.get(tagId)); ++tagId) {
                this.oracleSidTagIsSidSerial = false;
            }
        }
        if (tagId == length) {
            return;
        }
        this.oracleSidTagID = tagId;
        this.sids = new HashSet<String>();
        this.collectSessions(agg.getRoot());
        this.sids.remove("::other");
        if (this.sids.isEmpty()) {
            return;
        }
        this.fetchReport(agg);
    }

    private void collectSessions(Hotspot root) {
        if (root.children != null) {
            for (Hotspot child : root.children) {
                this.collectSessions(child);
            }
        }
        if (root.tags == null) {
            return;
        }
        for (HotspotTag tag : root.tags.values()) {
            int brace;
            if (tag.id != this.oracleSidTagID) continue;
            Object val = tag.value;
            String value = null;
            if (val instanceof String) {
                value = (String)val;
            } else if (val instanceof StringValue) {
                value = ((StringValue)val).value;
            }
            if (value != null && (brace = value.indexOf(40)) != -1) {
                value = value.substring(0, brace);
            }
            this.sids.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchReport(ProfiledTree agg) {
        Connection con = null;
        Statement ps = null;
        Statement s = null;
        ResultSet rs = null;
        this.out.print("CT.dbStats=[\"");
        try {
            StringBuilder errorMessage = new StringBuilder();
            if (PropertyFacade.getProperty("org.qubership.profiler.awr.disabled", false)) {
                errorMessage.append("Property -Dorg.qubership.profiler.awr.disabled=").append(PropertyFacade.getProperty("org.qubership.profiler.awr.disabled", false)).append("disables AWR usage. ");
            }
            if (!PropertyFacade.getProperty("org.qubership.profiler.awr.enabled", false) && !System.getProperty("qubership.naming.provider.url", "").toLowerCase().contains(".qubership.org")) {
                if (errorMessage.length() > 0) {
                    errorMessage.append('\n');
                }
                errorMessage.append("Property -Dorg.qubership.profiler.awr.enabled is equal to").append(PropertyFacade.getProperty("org.qubership.profiler.awr.enabled", false)).append(" (is not set to positive value), nor -Dqubership.naming.provider.url=").append(System.getProperty("qubership.naming.provider.url", "")).append(" contains '.qubership.org'");
            }
            if (errorMessage.length() > 0) {
                throw new IllegalAccessException(errorMessage.toString()){

                    @Override
                    public Throwable fillInStackTrace() {
                        return this;
                    }
                };
            }
            long aTime = agg.getRoot().startTime;
            long zTime = agg.getRoot().endTime;
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup("QubershipDataSource");
            con = ds.getConnection();
            s = con.createStatement();
            Calendar UTC = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            long t0 = System.currentTimeMillis();
            rs = s.executeQuery("select d.dbid            dbid\n     , systimestamp systime\n     , version\n  from v$database d, v$instance");
            if (!rs.next()) {
                throw new IllegalStateException("Unable to fetch v$database and v$instance info");
            }
            Timestamp nowAtDatabase = rs.getTimestamp(2, UTC);
            long t1 = System.currentTimeMillis();
            long dbTime = nowAtDatabase.getTime();
            long dbid = rs.getLong(1);
            final boolean oracle11gR2 = rs.getString(3).compareTo("11.2") >= 0;
            rs.close();
            rs = null;
            s.close();
            s = null;
            Timestamp aTimestamp = new Timestamp(aTime - t1 + dbTime);
            Timestamp zTimestamp = new Timestamp(zTime - t0 + dbTime);
            if (oracle11gR2) {
                ps = con.prepareStatement("select systimestamp+(oldest_sample_time-cast(systimestamp as timestamp)) from v$ash_info");
            } else {
                ps = con.prepareStatement("select systimestamp+(coalesce(\n         (select min(sample_time)\n            from v$active_session_history\n           where SAMPLE_TIME < cast(from_tz(?, 'UTC') as timestamp with local time zone)+(cast(systimestamp as timestamp)-systimestamp) and rownum=1\n         ),\n         (select min(sample_time)\n            from v$active_session_history\n           where SAMPLE_TIME < cast(from_tz(?, 'UTC') as timestamp with local time zone)+(cast(systimestamp as timestamp)-systimestamp))\n        )-cast(systimestamp as timestamp))\n  from dual\n");
                ps.setTimestamp(1, aTimestamp, UTC);
                ps.setTimestamp(2, zTimestamp, UTC);
            }
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new IllegalStateException("Unable to fetch oldest_sample_time");
            }
            Timestamp oldestASHSample = rs.getTimestamp(1, UTC);
            rs.close();
            rs = null;
            ps.close();
            ps = null;
            int minSnap = 0;
            int maxSnap = 0;
            if (oldestASHSample != null && oldestASHSample.getTime() > aTimestamp.getTime()) {
                ps = oracle11gR2 ? con.prepareStatement("select min(snap_id) a, max(snap_id) b from dba_hist_ash_snapshot\n where from_tz(END_INTERVAL_TIME - SNAP_TIMEZONE, 'UTC') > from_tz(?, 'UTC')\n   and from_tz(BEGIN_INTERVAL_TIME - SNAP_TIMEZONE, 'UTC') < from_tz(?, 'UTC')") : con.prepareStatement("select min(snap_id) a, max(snap_id) b from dba_hist_snapshot\n where END_INTERVAL_TIME > cast(from_tz(?, 'UTC') as timestamp with local time zone)+(cast(systimestamp as timestamp)-systimestamp)\n   and BEGIN_INTERVAL_TIME < cast(from_tz(?, 'UTC') as timestamp with local time zone)+(cast(systimestamp as timestamp)-systimestamp)");
                ps.setTimestamp(1, aTimestamp, UTC);
                ps.setTimestamp(2, oldestASHSample, UTC);
                rs = ps.executeQuery();
                if (!rs.next()) {
                    throw new IllegalStateException("Unable to fetch relevant dba_hist_snaphost ids");
                }
                minSnap = rs.getInt(1);
                maxSnap = rs.getInt(2);
                rs.close();
                rs = null;
                ps.close();
                ps = null;
            }
            ps = con.prepareStatement("SELECT sql_id, SQL_CHILD_NUMBER, plan_hash_value, CNT, TM_DELTA_DB_TIME, TM_DELTA_CPU_TIME\n  ,coalesce((SELECT SQL_TEXT from DBA_HIST_SQLTEXT WHERE dbid=? and sql_id = x.sql_id), (select sql_fulltext from v$sql where sql_id=x.sql_id and rownum=1)) sql_text\n  ,cursor(select depth               , operation || ' ' || options operation\n               , decode(object_type,'PROCEDURE',object_owner||'.')||nvl(object_name,' ') object_name\n               , object_alias\n               , cost\n               , cardinality\n               , access_predicates\n               , filter_predicates\n               , nvl(search_columns,0)\n            from v$sql_plan\n            where sql_id=x.sql_id and plan_hash_value=x.plan_hash_value and child_number=SQL_CHILD_NUMBER             order by child_number, id\n   ) plana\n  ,cursor(select depth               , operation || ' ' || options operation\n               , decode(object_type,'PROCEDURE',object_owner||'.')||nvl(object_name,' ') object_name\n               , object_alias\n               , cost\n               , cardinality\n               , access_predicates\n               , filter_predicates\n               , nvl(search_columns,0)\n            from dba_hist_sql_plan\n            where dbid=? and sql_id=x.sql_id and plan_hash_value=x.plan_hash_value\n             order by id\n   ) planb\n" + (oracle11gR2 ? ", DELTA_READ_IO_REQUESTS, DELTA_WRITE_IO_REQUESTS, DELTA_READ_IO_BYTES, DELTA_WRITE_IO_BYTES, PGA_ALLOCATED, TEMP_SPACE_ALLOCATED\n" : "") + "   FROM (SELECT\n           SQL_ID, SQL_CHILD_NUMBER, plan_hash_value, count(*) cnt, sum(TM_DELTA_DB_TIME)/1000000 TM_DELTA_DB_TIME, sum(TM_DELTA_CPU_TIME)/1000000 TM_DELTA_CPU_TIME\n" + (oracle11gR2 ? ", sum(DELTA_READ_IO_REQUESTS) DELTA_READ_IO_REQUESTS, sum(DELTA_WRITE_IO_REQUESTS) DELTA_WRITE_IO_REQUESTS, sum(DELTA_READ_IO_BYTES) DELTA_READ_IO_BYTES, sum(DELTA_WRITE_IO_BYTES) DELTA_WRITE_IO_BYTES, max(PGA_ALLOCATED) PGA_ALLOCATED, max(TEMP_SPACE_ALLOCATED) TEMP_SPACE_ALLOCATED\n" : "") + "   FROM\n  (\n" + (minSnap != 0 ? "     SELECT SESSION_ID, SESSION_SERIAL#, SQL_ID, SQL_CHILD_NUMBER, sql_plan_hash_value plan_hash_value, SESSION_STATE, SAMPLE_TIME\n" + (oracle11gR2 ? ", CASE WHEN TM_DELTA_DB_TIME<15000000 THEN TM_DELTA_DB_TIME ELSE DECODE(SESSION_STATE,'ON CPU',0,10000000) END TM_DELTA_DB_TIME\n, CASE WHEN TM_DELTA_CPU_TIME<15000000 THEN TM_DELTA_CPU_TIME ELSE DECODE(SESSION_STATE,'ON CPU',10000000) END TM_DELTA_CPU_TIME\n, DELTA_READ_IO_REQUESTS, DELTA_WRITE_IO_REQUESTS, DELTA_READ_IO_BYTES, DELTA_WRITE_IO_BYTES\n, PGA_ALLOCATED, TEMP_SPACE_ALLOCATED\n" : ", DECODE(SESSION_STATE,'ON CPU',0,10000000) TM_DELTA_DB_TIME, DECODE(SESSION_STATE,'ON CPU',10000000) TM_DELTA_CPU_TIME\n") + "       FROM DBA_HIST_ACTIVE_SESS_HISTORY\n      WHERE DBID=? AND INSTANCE_NUMBER=USERENV('INSTANCE')\n        AND SNAP_ID BETWEEN ? AND ?\n        AND SAMPLE_TIME < cast(from_tz(?, 'UTC') as timestamp with local time zone)+(cast(systimestamp as timestamp)-systimestamp)\n  UNION ALL\n" : "") + "     SELECT SESSION_ID, SESSION_SERIAL#, SQL_ID, SQL_CHILD_NUMBER, sql_plan_hash_value plan_hash_value, SESSION_STATE, SAMPLE_TIME\n" + (oracle11gR2 ? ", TM_DELTA_DB_TIME, TM_DELTA_CPU_TIME, DELTA_READ_IO_REQUESTS, DELTA_WRITE_IO_REQUESTS, DELTA_READ_IO_BYTES, DELTA_WRITE_IO_BYTES\n, PGA_ALLOCATED, TEMP_SPACE_ALLOCATED\n" : ", DECODE(SESSION_STATE,'ON CPU',0,1000000) TM_DELTA_DB_TIME, DECODE(SESSION_STATE,'ON CPU',1000000) TM_DELTA_CPU_TIME\n") + "       FROM V$ACTIVE_SESSION_HISTORY\n  )\n  x\n  WHERE SAMPLE_TIME BETWEEN cast(from_tz(?, 'UTC') as timestamp with local time zone)+(cast(systimestamp as timestamp)-systimestamp) AND cast(from_tz(?, 'UTC') as timestamp with local time zone)+(cast(systimestamp as timestamp)-systimestamp)\n" + (this.oracleSidTagIsSidSerial ? "    AND (SESSION_ID, SESSION_SERIAL#) in (select /*+ cardinality(t 10) */ substr(column_value,1,instr(column_value,'.')-1), substr(column_value,instr(column_value,'.')+1) from table(cast(? as arrayofstrings)) t)\n" : "    AND SESSION_SERIAL# in (select /*+ cardinality(t 10) */ column_value from table(cast(? as arrayofstrings)) t)\n") + "  GROUP BY SQL_ID, SQL_CHILD_NUMBER, plan_hash_value) x\nORDER BY nvl(TM_DELTA_DB_TIME,0)+nvl(TM_DELTA_CPU_TIME,0) DESC NULLS LAST");
            int bind = 1;
            ps.setLong(bind++, dbid);
            ps.setLong(bind++, dbid);
            if (minSnap != 0) {
                ps.setLong(bind++, dbid);
                ps.setInt(bind++, minSnap);
                ps.setInt(bind++, maxSnap);
                ps.setTimestamp(bind++, oldestASHSample, UTC);
            }
            ps.setTimestamp(bind++, aTimestamp, UTC);
            ps.setTimestamp(bind++, zTimestamp, UTC);
            ps.setArray(bind, ActiveSessionHistoryFetcher.createArray(con, "ARRAYOFSTRINGS", this.sids.toArray()));
            rs = ps.executeQuery();
            this.out.print("Begin timestamp: \",new Date(");
            this.out.print(aTime);
            this.out.print(").toLocaleString(),\"<br>\",\n\"");
            this.out.print("End timestamp: \",new Date(");
            this.out.print(zTime);
            this.out.print(").toLocaleString(),\"<br>\",\n\"");
            this.out.print("Oracle session sid.serial#: ");
            Iterator<String> sidsIter = this.sids.iterator();
            this.out.print(sidsIter.next());
            while (sidsIter.hasNext()) {
                String sid = sidsIter.next();
                this.out.print(',');
                this.out.print(' ');
                this.out.print((Object)sid);
            }
            this.out.print("<br>\",\n\"");
            this.out.print("ASH condition: <pre class='prettyprint lang-sql' style='max-height:100%;'>\",prettyPrintOne(\"select * from v$active_session_history -- dba_hist_active_sess_history\\n");
            this.out.print(" where ");
            this.out.print("sample_time between");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.out.print(" cast(to_timestamp_tz('");
            this.out.print(sdf.format(aTimestamp));
            this.out.print(" UTC','YYYY-MM-DD HH24:MI:SS.FF TZR') as timestamp with local time zone)+(cast(systimestamp as timestamp)-systimestamp)");
            this.out.print("\\n   and cast(to_timestamp_tz('");
            this.out.print(sdf.format(zTimestamp));
            this.out.print(" UTC','YYYY-MM-DD HH24:MI:SS.FF TZR') as timestamp with local time zone)+(cast(systimestamp as timestamp)-systimestamp)");
            this.out.print(this.oracleSidTagIsSidSerial ? "\\n   and (session_id, session_serial#) in (select /*+ cardinality(t 10) */ substr(column_value,1,instr(column_value,'.')-1), substr(column_value,instr(column_value,'.')+1) " : "\\n   and session_serial# in (select /*+ cardinality(t 10) */ column_value ");
            this.out.print("from table(arrayofstrings('");
            sidsIter = this.sids.iterator();
            this.out.print(sidsIter.next());
            this.out.print('\'');
            while (sidsIter.hasNext()) {
                String sid = sidsIter.next();
                this.out.print(',');
                this.out.print('\'');
                this.out.print((Object)sid);
                this.out.print('\'');
            }
            this.out.print(")) t)\\n--   and dbid=");
            this.out.print(dbid);
            if (minSnap > 0) {
                this.out.print("\\n--   and snap_id between ");
                this.out.print(minSnap);
                this.out.print(" and ");
                this.out.print(maxSnap);
            }
            this.out.print(" -- for dba_hist_active_session_history\",\"sql\"),\"</pre><br>");
            if (Math.max(Math.abs(dbTime - t0), Math.abs(dbTime - t1)) > 2000L) {
                this.out.print("<span class=r>Database clock is ");
                this.out.print(TimeHelper.humanizeDifference(null, dbTime - t0));
                if (t1 - t0 > 500L) {
                    this.out.print(" .. ");
                    this.out.print(TimeHelper.humanizeDifference(null, dbTime - t1));
                }
                this.out.print(" compared to application server</span><br>\",\n\"");
                this.out.print("Database thinks current time is: \",new Date(");
                this.out.print(dbTime);
                this.out.print(").toUTCString(),\" (\",new Date(");
                this.out.print(dbTime);
                this.out.print(").toLocaleString(),\" in browser time zone)<br>\",\n\"");
            }
            this.out.print("Elapsed seconds: ");
            this.out.print((zTime - aTime) / 1000L);
            double timeFactor = 0.0;
            if (zTime - aTime > 0L) {
                timeFactor = 60000.0 / (double)(zTime - aTime);
            }
            double cutoffDuration = 1.0E-4 * (double)(zTime - aTime);
            this.out.print("<table border=1 cellpadding=1 cellspacing=0>\",\n\"");
            if (oracle11gR2) {
                this.out.print("<tr><th>sql_id</th><th>plan hash value</th><th>time</th><th>cpu time</th><th>IO read</th><th>IO write</th><th>Memory</th><th>SQL</th><th>plan</th></tr>\",\n\"");
            } else {
                this.out.print("<tr><th>sql_id</th><th>plan hash value</th><th>time</th><th>cpu time</th><th>SQL</th><th>plan</th></tr>\",\n\"");
            }
            int i = 0;
            while (rs.next()) {
                String sql = rs.getString(COL_SQL_TEXT);
                boolean bigSql = JSHelper.hasNLines(sql, 12);
                this.out.print(i % 2 == 0 ? "<tr w=1 class='e" : "<tr w=1 class='o");
                this.out.print("'><td>");
                String sqlId = rs.getString(COL_SQL_ID);
                ActiveSessionHistoryFetcher.printSqlId(this.out, sqlId, oracle11gR2);
                this.out.print("<br>child# ");
                this.out.print(rs.getString(COL_SQL_CHILD));
                this.out.print("</td><td class=nmbr>");
                this.out.print(rs.getString(COL_PLAN_HASH_VALUE));
                this.out.print("<br>");
                String samples = rs.getString(COL_COUNT);
                this.out.print(samples);
                this.out.print("1".equals(samples) ? " sample" : " samples");
                this.out.print("</td><td class=nmbr>");
                double tim = rs.getDouble(COL_DB_TIME);
                double cpuTim = rs.getDouble(COL_DB_CPU_TIME);
                this.out.print(this.nfTime.format(tim));
                this.out.print('s');
                if (tim > cutoffDuration) {
                    this.out.print("<br>");
                    this.out.print("<span style='vertical-align:2px;font-size:7px; background:#8b0000;'><img src='data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==' height=1 width=");
                    this.out.print(Math.round(tim * timeFactor));
                    this.out.print("></span>");
                }
                this.out.print("</td><td class=nmbr>");
                this.out.print(this.nfTime.format(cpuTim));
                this.out.print('s');
                if (cpuTim > cutoffDuration) {
                    this.out.print("<br>");
                    this.out.print("<span style='vertical-align:2px;font-size:7px; background:#8b0000;'><img src='data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==' height=1 width=");
                    this.out.print(Math.round(cpuTim * timeFactor));
                    this.out.print("></span>");
                }
                if (oracle11gR2) {
                    this.out.print("</td><td class=nmbr>");
                    this.printIOStats(this.out, rs.getLong(COL_READ_REQS), rs.getLong(COL_READ_BYTES));
                    this.out.print("</td><td class=nmbr>");
                    this.printIOStats(this.out, rs.getLong(COL_WRITE_REQS), rs.getLong(COL_WRITE_BYTES));
                    this.out.print("</td><td class=nmbr>");
                    long pga = rs.getLong(COL_PGA);
                    this.out.print(this.humanizedToString(pga, 1024, KILO_BYTES, pga > 0x1400000L));
                    this.out.print(" PGA<br>");
                    long temp = rs.getLong(COL_TEMP);
                    this.out.print(this.humanizedToString(temp, 1024, KILO_BYTES, temp > 0xA00000L));
                    this.out.print(" TEMP");
                }
                this.out.print("</td><td");
                if (bigSql) {
                    this.out.print(" class=b");
                }
                this.out.print(">\"\n,CT.printReformatted([], \"");
                JSHelper.escapeJS(this.out, sql);
                this.out.print("\",\"sql\",0,\"lang-sql s\").join(\"\")\n,\"</pre></td>\",\n\"");
                this.out.print("</td><td class=");
                this.out.print(bigSql ? (char)'b' : 'y');
                this.out.print("><div class=t>\",\n\"");
                ResultSet plan = (ResultSet)rs.getObject(COL_SQL_PLANA);
                boolean shouldClose8 = true;
                if (!plan.next()) {
                    plan.close();
                    plan = (ResultSet)rs.getObject(COL_SQL_PLANB);
                    shouldClose8 = false;
                }
                if (shouldClose8 || plan.next()) {
                    this.out.print("<table class=ms border=0 cellpadding=1 cellspacing=0>\",\n\"");
                    this.out.print("<tr><th>operation</th><th>object</th><th>cost</th><th>cardinality</th><th>predicates</th></tr>\",\n\"");
                    int j = 0;
                    while (true) {
                        this.out.print(j % 2 == 0 ? "<tr class='e" : "<tr class='o");
                        this.out.flush();
                        String operation = plan.getString(2);
                        String objectName = plan.getString(3);
                        int searchColumns = plan.getInt(9);
                        BigDecimal cost = plan.getBigDecimal(5);
                        BigDecimal cardinality = plan.getBigDecimal(6);
                        if (operation != null && (operation.indexOf("FULL") != -1 || operation.indexOf("SKIP") != -1) || "XIF26NC_PARAMS".equals(objectName) && searchColumns <= 1 || "XIF01NC_REFERENCES".equals(objectName) || "XIF10NC_OBJECTS".equals(objectName) || cardinality != null && cardinality.compareTo(THOUSAND) >= 0 || operation != null && operation.indexOf("COLLECTION") != -1 && BigDecimal.ZERO.equals(cardinality)) {
                            this.out.print(" r");
                        }
                        this.out.print("'>");
                        this.out.print("<td style='padding-left:");
                        this.out.print((float)plan.getInt(1) * 0.7f);
                        this.out.print("em;'>");
                        this.out.print(operation != null ? operation.replaceAll(" ", "&nbsp;") : "");
                        this.out.print("</td><td>");
                        this.out.print(objectName);
                        String alias = plan.getString(4);
                        if (alias != null) {
                            this.out.print("&nbsp;");
                            int at = alias.indexOf(64);
                            if (at != -1) {
                                alias = alias.substring(0, at);
                            }
                            if (!objectName.endsWith(alias)) {
                                this.out.print("<span class=g>");
                                JSHelper.escapeJS(this.out, JSHelper.escapeHTML(alias));
                                this.out.print("</span>");
                            }
                        }
                        this.out.print("</td><td class=nmbr>");
                        this.out.print(this.humanizedToString(cost, 1000, KILOS, cost == null ? false : cost.compareTo(FIVE_THOUSAND) > 0));
                        this.out.print("</td><td class=nmbr>");
                        this.out.print(this.humanizedToString(cardinality, 1000, KILOS, cardinality == null ? false : cardinality.compareTo(THOUSAND) > 0));
                        this.out.print("</td><td>");
                        String accessPredicates = plan.getString(7);
                        String filterPredicates = plan.getString(8);
                        if (accessPredicates != null) {
                            this.out.print("<b>ACCESS:</b> \",\n\"");
                            JSHelper.escapeJS(this.out, JSHelper.escapeHTML(accessPredicates));
                            if (filterPredicates != null) {
                                this.out.print("<br>");
                            }
                        }
                        if (filterPredicates != null) {
                            this.out.print("<b>FILTER:</b> \",\n\"");
                            JSHelper.escapeJS(this.out, JSHelper.escapeHTML(filterPredicates));
                        }
                        this.out.print("</td><td>");
                        this.out.print("</tr>\",\n\"");
                        if (!plan.next()) break;
                        ++j;
                    }
                    this.out.print("</table>\",\n\"");
                }
                plan.close();
                if (shouldClose8) {
                    ((ResultSet)rs.getObject(COL_SQL_PLANB)).close();
                }
                this.out.print("</div></td>\",\n\"");
                this.out.print("</tr>\",\n\"");
                ++i;
            }
            this.out.print("</table>");
            StackedChart[][] ashChartData = this.getASHChartData(con, UTC, dbid, aTimestamp, zTimestamp, oldestASHSample, minSnap, maxSnap);
            if (ashChartData != null) {
                this.out.print("\"].join('');");
                String[] groups = new String[]{"event", "sql_id", "user"};
                List<UnaryFunction> labelMappers = Arrays.asList(new UnaryFunction<String, String>(){

                    @Override
                    public String evaluate(String arg) {
                        String htmlSafe = JSHelper.escapeHTML(arg);
                        try {
                            return "<a target=_blank href='https://www.google.com/search?q=" + URLEncoder.encode(arg, "UTF-8") + "'>" + htmlSafe + "</a>";
                        }
                        catch (UnsupportedEncodingException e) {
                            return htmlSafe;
                        }
                    }
                }, new UnaryFunction<String, String>(){

                    @Override
                    public String evaluate(String arg) {
                        return ActiveSessionHistoryFetcher.printSqlId(new StringWriter(), arg, oracle11gR2).toString();
                    }
                }, null);
                for (int i2 = 0; i2 < ashChartData.length; ++i2) {
                    StackedChart[] charts = ashChartData[i2];
                    this.out.print("\nCT.ashData.");
                    this.out.print(groups[i2]);
                    this.out.print("= [");
                    for (int j = 0; j < charts.length; ++j) {
                        if (j > 0) {
                            this.out.print("\n,");
                        }
                        StackedChart chart = charts[j];
                        chart.toJS(this.out, labelMappers.get(i2));
                    }
                    this.out.print("];");
                }
                this.out.print("\n[\"");
            }
        }
        catch (Throwable e) {
            log.warn("Unable to get active session history for {}", (Object)agg, (Object)e);
            this.saveException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException errorMessage) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException errorMessage) {}
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException errorMessage) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException errorMessage) {}
            }
        }
        if (this.exceptions != null) {
            this.out.print("\"].join('');\nCT.dbExceptions=[\"<h2>Errors detected when accessing active session information</h2><br><pre>");
            try {
                for (Throwable t : this.exceptions) {
                    JSHelper.escapeJS(this.out, JSHelper.escapeHTML(ThrowableHelper.throwableToString(t)));
                    this.out.print("\\n\",\n\"");
                }
            }
            catch (IOException e) {
                log.error("", e);
            }
        }
        this.out.print("\"].join('');\n");
    }

    private static Writer printSqlId(Writer out, String sqlId, boolean oracle11gR2) {
        try {
            out.append("<a target=_blank href='/tools/db150.jsp?sql=");
            out.append(oracle11gR2 ? "select%20dbms_sqltune.report_sql_monitor(%27" : "select%20*%20from%20table(dbms_xplan.display_awr(%27");
            out.append(sqlId);
            out.append(oracle11gR2 ? "%27,report_level=>%27ALL%27)%20plan_table_output%20from%20dual" : "%27,null,null,%27ALL%27))");
            out.append(";%0aselect+*+from+table(dbms_xplan.display_cursor(%27");
            out.append(sqlId);
            out.append("%27,null,%27allstats%20last%20%2Bpeeked_binds%27));&lob_output=fulllobs&act=execute'>");
            out.append(sqlId);
            out.append("</a>");
        }
        catch (IOException e) {
            log.warn("Unable to write sql_id {} to resulting javascript", (Object)sqlId, (Object)e);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StackedChart[][] getASHChartData(Connection con, Calendar UTC, long dbid, Timestamp aTimestamp, Timestamp zTimestamp, Timestamp oldestASHSample, int minSnap, int maxSnap) throws SQLException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement("SELECT round(((((extract(day from st)*24+extract(hour from st))*60+extract(minute from st))*60)+extract(second from st))*1000) st\n  , our_session\n  , group_id\n  , cnt\n  , v_event\n  , v_sql_id\n  , v_user\n FROM (\n  SELECT sample_time\n  , ((systimestamp-TIMESTAMP '1970-01-01 00:00:00 +00:00')+(sample_time-cast(systimestamp as timestamp))) st\n  , grouping(decode(sids.session_id,null,1)) our_session\n  , grouping_id(user_id, sql_id, event) group_id\n  , count(*) cnt\n  , decode(grouping(event), 0, nvl(event, 'CPU')) v_event\n  , decode(grouping(sql_id), 0, nvl(sql_id, 'no sql_id')) v_sql_id\n  , decode(grouping(user_id), 0, (select username from dba_users where user_id=s.user_id)) v_user\n FROM (\n   SELECT sample_time, event, sql_id, user_id, session_id, session_serial# FROM v$active_session_history\n" + (minSnap != 0 ? " UNION ALL SELECT sample_time, event, sql_id, user_id, session_id, session_serial# FROM DBA_HIST_ACTIVE_SESS_HISTORY\n    WHERE DBID=? AND INSTANCE_NUMBER=USERENV('INSTANCE')\n      AND SNAP_ID BETWEEN ? AND ?\n      AND SAMPLE_TIME < cast(from_tz(?, 'UTC') as timestamp with local time zone)+(cast(systimestamp as timestamp)-systimestamp)\n" : "") + ") s \n" + (this.oracleSidTagIsSidSerial ? ", (select /*+ cardinality(t 10) */ substr(column_value,1,instr(column_value,'.')-1) session_id, substr(column_value,instr(column_value,'.')+1) session_serial# from table(cast(? as arrayofstrings)) t) sids\n" : ", (select /*+ cardinality(t 10) */ column_value session_id from table(cast(? as arrayofstrings)) t) sids\n") + "  WHERE SAMPLE_TIME BETWEEN cast(from_tz(?, 'UTC') as timestamp with local time zone)+(cast(systimestamp as timestamp)-systimestamp) AND cast(from_tz(?, 'UTC') as timestamp with local time zone)+(cast(systimestamp as timestamp)-systimestamp)\n    and sids.session_id(+) = s.session_id\n" + (this.oracleSidTagIsSidSerial ? "    and sids.session_serial#(+) = s.session_serial#\n" : "") + "GROUP BY sample_time, rollup(decode(sids.session_id,null,1)), grouping sets((event),(sql_id),(user_id))\nHAVING decode(sids.session_id,null,1) is null /* We need just our sessions or totals. */\n)\nORDER BY sample_time, group_id");
            int bind = 1;
            if (minSnap != 0) {
                ps.setLong(bind++, dbid);
                ps.setInt(bind++, minSnap - 1);
                ps.setInt(bind++, maxSnap + 1);
                ps.setTimestamp(bind++, oldestASHSample, UTC);
            }
            ps.setArray(bind++, ActiveSessionHistoryFetcher.createArray(con, "ARRAYOFSTRINGS", this.sids.toArray()));
            Timestamp chartA = aTimestamp;
            Timestamp chartZ = zTimestamp;
            long dt = chartZ.getTime() - chartA.getTime();
            if (dt != 0L) {
                chartA.setTime(chartA.getTime() - Math.min(dt / 10L, 5000L));
                chartZ.setTime(chartZ.getTime() + Math.min(dt / 10L, 5000L));
            }
            ps.setTimestamp(bind++, chartA, UTC);
            ps.setTimestamp(bind++, chartZ, UTC);
            int idx = 1;
            int COL_SAMPLE_TIME = idx++;
            int COL_OUR_SESSION = idx++;
            int COL_GROUP_ID = idx++;
            int COL_COUNT = idx++;
            int COL_EVENT = idx++;
            int COL_SQL_ID = idx++;
            int COL_USER = idx++;
            StackedChart[][] data = new StackedChart[3][2];
            String[] groups = new String[]{"event", "sql_id", "user"};
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < data[i].length; ++j) {
                    String gr = groups[i];
                    data[i][j] = new StackedChart(j == 0 ? Character.toUpperCase(gr.charAt(0)) + gr.substring(1) + "s in our session" : "All sessions by " + gr);
                }
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                long time = rs.getLong(COL_SAMPLE_TIME);
                int groupingId = rs.getInt(COL_GROUP_ID);
                int chartTypeIndex = Integer.numberOfTrailingZeros(~groupingId);
                int ourSession = rs.getInt(COL_OUR_SESSION);
                int cnt = rs.getInt(COL_COUNT);
                String label = rs.getString(COL_EVENT + chartTypeIndex);
                data[chartTypeIndex][ourSession].add(time, label, cnt);
            }
            StackedChart[][] stackedChartArray = data;
            return stackedChartArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void printIOStats(PrintWriter out, long ios, long bytes) {
        out.print(this.humanizedToString(ios, 1000, KILO_IOPS, ios > 5000L));
        out.print("<br>");
        out.print(this.humanizedToString(bytes, 1024, KILO_BYTES, bytes > 40960000L));
    }

    private String humanizedToString(long value, int k, String[] magnitudes, boolean red) {
        StringBuffer sb = new StringBuffer();
        if (red) {
            sb.append("<ins>");
        }
        if (value < 100000L) {
            sb.append("<s>").append(value).append(magnitudes[0]).append("</s>");
        } else if (value < 10000000L) {
            sb.append(Math.round(value / 1000L)).append(magnitudes[1]);
        } else if (value < 10000000000L) {
            sb.append(Math.round(value / 1000000L)).append(magnitudes[2]);
        } else {
            sb.append(Math.round(value / 1000000000L)).append(magnitudes[3]);
        }
        if (red) {
            sb.append("</ins>");
        }
        return sb.toString();
    }

    private String humanizedToString(BigDecimal value, int k, String[] magnitudes, boolean red) {
        if (value == null) {
            return "";
        }
        try {
            return this.humanizedToString(value.longValue(), k, magnitudes, red);
        }
        catch (ArithmeticException arithmeticException) {
            StringBuffer sb = new StringBuffer();
            if (red) {
                sb.append("<ins>");
            }
            if (value.compareTo(X_10_0000) < 0) {
                sb.append("<s>").append(value).append(magnitudes[0]).append("</s>");
            } else if (value.compareTo(X_10_000_000) < 0) {
                sb.append(value.divideToIntegralValue(X_1_000)).append(magnitudes[1]);
            } else if (value.compareTo(X_10_000_000_000) < 0) {
                sb.append(value.divideToIntegralValue(X_1_000_000)).append(magnitudes[2]);
            } else {
                sb.append(value.divideToIntegralValue(X_1_000_000_000)).append(magnitudes[3]);
            }
            if (red) {
                sb.append("</ins>");
            }
            return sb.toString();
        }
    }

    private static Array createArray(Connection con, String sqlType, Object[] objects) throws ClassNotFoundException, SQLException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Method mGetVendorConnection = con.getClass().getMethod("getVendorConnection", new Class[0]);
        Connection oracleConnection = (Connection)mGetVendorConnection.invoke((Object)con, new Object[0]);
        Class<?> cArrayDescriptor = Class.forName("oracle.sql.ArrayDescriptor");
        Method mCreateDescriptor = cArrayDescriptor.getMethod("createDescriptor", String.class, Connection.class);
        Object arrayofnumbers = mCreateDescriptor.invoke(null, sqlType, oracleConnection);
        Class<?> cARRAY = Class.forName("oracle.sql.ARRAY");
        Constructor<?> constructorARRAY = cARRAY.getConstructor(cArrayDescriptor, Connection.class, Object.class);
        return (Array)constructorARRAY.newInstance(arrayofnumbers, oracleConnection, objects);
    }

    private void saveException(Throwable e) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<Throwable>();
        }
        this.exceptions.add(e);
    }
}

