/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.IOException;
import java.io.Writer;

public class JSHelper {
    static final char[] hex = "0123456789ABCDEF".toCharArray();

    public static void escapeJS(Writer out, String s) throws IOException {
        if (s != null) {
            JSHelper.escapeJS(out, s, 0, s.length());
        }
    }

    public static void escapeJS(Writer out, String s, int offs, int len) throws IOException {
        char[] hex = JSHelper.hex;
        if (s == null) {
            return;
        }
        len = Math.min(len, s.length());
        block10: for (int i = offs; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    out.write(92);
                    out.write(34);
                    continue block10;
                }
                case '\\': {
                    out.write(92);
                    out.write(92);
                    continue block10;
                }
                case '\b': {
                    out.write(92);
                    out.write(98);
                    continue block10;
                }
                case '\f': {
                    out.write(92);
                    out.write(102);
                    continue block10;
                }
                case '\n': {
                    out.write(92);
                    out.write(110);
                    continue block10;
                }
                case '\r': {
                    out.write(92);
                    out.write(114);
                    continue block10;
                }
                case '\t': {
                    out.write(92);
                    out.write(116);
                    continue block10;
                }
                case '/': {
                    out.write(92);
                    out.write(47);
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        out.write(hex[ch >>> 12]);
                        out.write(hex[ch >>> 8 & 0xF]);
                        out.write(hex[ch >>> 4 & 0xF]);
                        out.write(hex[ch & 0xF]);
                        continue block10;
                    }
                    out.write(ch);
                }
            }
        }
    }

    public static String escapeHTML(String src) {
        if (src == null) {
            return null;
        }
        return src.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static boolean hasNLines(String s, int nlines) {
        if (s == null || s.length() == 0) {
            return nlines <= 1;
        }
        int pos = 0;
        while (pos != -1 && nlines > 1) {
            pos = s.indexOf(10, pos + 1);
            --nlines;
        }
        return nlines <= 1;
    }
}

