/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.File;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.profiler.agent.Bootstrap;
import org.qubership.profiler.agent.Configuration_01;
import org.qubership.profiler.agent.DumperPlugin;
import org.qubership.profiler.agent.DumperPlugin_01;
import org.qubership.profiler.agent.ParameterInfo;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.agent.ProfilerTransformerPlugin;
import org.qubership.profiler.configuration.ParameterInfoDto;
import org.qubership.profiler.io.ParamReaderFile;

public class ParamReaderFromMemory
extends ParamReaderFile {
    public ParamReaderFromMemory(File root) {
        super(root);
        Configuration_01.class.getName();
        DumperPlugin_01.class.getName();
    }

    @Override
    public Map<String, ParameterInfoDto> fillParamInfo(Collection<Throwable> exceptions, String rootReference) {
        if (this.canReadFromMemory(this.root)) {
            ProfilerTransformerPlugin transformer = Bootstrap.getPlugin(ProfilerTransformerPlugin.class);
            Configuration_01 conf = (Configuration_01)transformer.getConfiguration();
            Map<String, ParameterInfo> infoMap = conf.getParametersInfo();
            HashMap<String, ParameterInfoDto> dtoMap = new HashMap<String, ParameterInfoDto>();
            for (Map.Entry<String, ParameterInfo> entry : infoMap.entrySet()) {
                ParameterInfo info = entry.getValue();
                ParameterInfoDto dto = new ParameterInfoDto(info.name);
                dto.big = info.big;
                dto.combined = info.combined;
                dto.deduplicate = info.deduplicate;
                dto.index = info.index;
                dto.list = info.list;
                dto.order = info.order;
                dto.signatureFunction = info.signatureFunction;
                dtoMap.put(entry.getKey(), dto);
            }
            return dtoMap;
        }
        return super.fillParamInfo(exceptions, rootReference);
    }

    @Override
    public List<String> fillTags(BitSet requredIds, Collection<Throwable> exceptions) {
        if (this.canReadFromMemory(this.root)) {
            return ProfilerData.getTags();
        }
        return super.fillTags(requredIds, exceptions);
    }

    private boolean canReadFromMemory(File root) {
        DumperPlugin_01 dumper = (DumperPlugin_01)Bootstrap.getPlugin(DumperPlugin.class);
        if (dumper == null) {
            return false;
        }
        File dumpRoot = dumper.getCurrentRoot();
        return dumpRoot != null && dumpRoot.getAbsolutePath().equals(root.getAbsolutePath());
    }
}

