/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.qubership.profiler.configuration.ParameterInfoDto;
import org.qubership.profiler.dom.ClobValues;
import org.qubership.profiler.dom.ProfiledTree;
import org.qubership.profiler.dom.TagDictionary;
import org.qubership.profiler.io.Hotspot;
import org.qubership.profiler.io.HotspotTag;
import org.qubership.profiler.io.HotspotToJson;
import org.qubership.profiler.io.Pair;
import org.qubership.profiler.io.serializers.JsonSerializer;
import org.qubership.profiler.sax.values.ClobValue;
import org.qubership.profiler.sax.values.StringValue;
import org.qubership.profiler.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.qubership.profiler.shaded.org.apache.commons.lang.StringUtils;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;
import org.qubership.profiler.util.ThrowableHelper;

public class TreeToJson
implements JsonSerializer<ProfiledTree> {
    protected final String treeVarName;
    private final int paramTrimSizeForUI;
    private static final Logger log = LoggerFactory.getLogger(TreeToJson.class);

    public TreeToJson(String treeVarName, int paramTrimSizeForUI) {
        this.treeVarName = treeVarName;
        this.paramTrimSizeForUI = paramTrimSizeForUI;
    }

    @Override
    public void serialize(ProfiledTree tree, JsonGenerator gen) throws IOException {
        gen.writeRaw("var S=CT.sqls, B=CT.xmls;\n");
        gen.writeRaw("var " + this.treeVarName + ";\n");
        if (tree == null) {
            return;
        }
        try {
            this.renderTags(tree.getDict(), gen);
            Map<String, Integer> folder2id = this.renderClobs(tree.getClobValues(), gen);
            gen.writeRaw(this.treeVarName + " = ");
            this.renderCallTree(tree, gen, folder2id);
            gen.writeRaw(";\n");
            gen.writeRaw(this.treeVarName + " = CT.append(" + this.treeVarName + ", []);\n");
        }
        catch (Throwable t) {
            log.error("", t);
            gen.writeRaw(ThrowableHelper.throwableToString(t));
        }
    }

    private List<Hotspot> collectSorted(Collection<List<Hotspot>> listOfLists) {
        ArrayList<Hotspot> collect = new ArrayList<Hotspot>();
        for (List<Hotspot> toCollect : listOfLists) {
            collect.addAll(toCollect);
        }
        Collections.sort(collect, new Comparator<Hotspot>(){

            @Override
            public int compare(Hotspot o1, Hotspot o2) {
                return Long.compare(o1.startTime, o2.startTime);
            }
        });
        return collect;
    }

    private void renderCallTree(ProfiledTree agg, JsonGenerator gen, Map<String, Integer> folder2id) throws IOException {
        HotspotToJson hs2js = new HotspotToJson(folder2id);
        Hotspot root = agg.getRoot();
        ArrayList<Hotspot> children = root.children;
        HashMap<Hotspot, List<Hotspot>> calculateList = new HashMap<Hotspot, List<Hotspot>>();
        if (children == null) {
            hs2js.serialize(new Hotspot(0), gen);
        } else if (children.size() == 1) {
            this.transformTree(root, root, this.getAllParents(root), calculateList, new AtomicInteger());
            this.remap(calculateList);
        } else {
            Map<Long, Hotspot> allParents = this.getAllParents(root);
            this.transformTree(root, root, allParents, calculateList, new AtomicInteger());
            this.remap(calculateList);
            List<Hotspot> collect = this.collectSorted(calculateList.values());
            for (Hotspot hotspot : collect) {
                long reactorStartTime = hotspot.reactorStartTime;
                long reactorLeastTime = reactorStartTime + (long)hotspot.reactorDuration;
                if (hotspot.isReactorFrame != 0) {
                    for (Hotspot hp : collect) {
                        if (hp.isReactorFrame == 0) continue;
                        long hpReactorStartTime = hp.reactorStartTime + 100L;
                        long hpReactorLeastTime = hp.reactorStartTime + (long)hp.reactorDuration - 100L;
                        boolean start = hpReactorStartTime >= reactorStartTime && hpReactorStartTime <= reactorLeastTime;
                        boolean end = hpReactorLeastTime >= reactorStartTime && hpReactorLeastTime <= reactorLeastTime;
                        boolean between = hpReactorStartTime <= reactorStartTime && hpReactorLeastTime >= reactorLeastTime;
                        for (HotspotTag ht : hotspot.tags.values()) {
                            if (!(ht.value instanceof StringValue) || !StringUtils.isNumeric(ht.value.toString())) continue;
                            if ((start || end || between) && hp.reactorCallId != hotspot.reactorCallId) {
                                ht.parallels.add(Pair.of(hp.id, hp.reactorDuration));
                                ht.isParallel = 1;
                            }
                            ht.reactorStartDate = hotspot.reactorStartTime;
                        }
                    }
                }
                this.calculate(root, hotspot.reactorCallId, hotspot, hotspot.id, false);
            }
            for (Hotspot hotspot : calculateList.keySet()) {
                HashMap<Integer, Hotspot> reactorIds = new HashMap<Integer, Hotspot>();
                Iterator<Hotspot> iterator = hotspot.children.iterator();
                while (iterator.hasNext()) {
                    Hotspot child = iterator.next();
                    if (reactorIds.containsKey(child.id)) {
                        Hotspot hp = (Hotspot)reactorIds.get(child.id);
                        hp.mergeWithChildren(child);
                        iterator.remove();
                        continue;
                    }
                    reactorIds.put(child.id, child);
                }
            }
        }
        long totalTime = 0L;
        if (children != null) {
            for (Hotspot child : children) {
                totalTime += child.totalTime;
                if (child.totalTime >= (long)child.reactorDuration) continue;
                totalTime += (long)child.reactorDuration;
                root.reactorDuration += child.reactorDuration;
            }
        }
        root.totalTime = root.childTime = totalTime;
        hs2js.serialize(root, gen);
    }

    private void remap(Map<Hotspot, List<Hotspot>> calculateList) {
        for (Map.Entry<Hotspot, List<Hotspot>> hotspotListEntry : calculateList.entrySet()) {
            Hotspot parent = hotspotListEntry.getKey();
            List<Hotspot> child = hotspotListEntry.getValue();
            if (parent.children == null) {
                parent.children = new ArrayList();
            }
            parent.children.addAll(child);
        }
    }

    private void transformTree(Hotspot root, Hotspot mainRoot, Map<Long, Hotspot> transform, Map<Hotspot, List<Hotspot>> calculateMap, AtomicInteger counter) {
        ArrayList<Hotspot> children = root.children;
        Iterator<Hotspot> iterator = children.iterator();
        while (iterator.hasNext()) {
            try {
                Hotspot hotspotLast;
                Hotspot child = iterator.next();
                if (child.children != null) {
                    this.transformTree(child, mainRoot, transform, calculateMap, counter);
                }
                if (child.lastParentAssemblyId == 0L || calculateMap == Collections.EMPTY_MAP || (hotspotLast = transform.get(child.lastParentAssemblyId)) == null || hotspotLast.children != null && hotspotLast.children.containsAll(root.children) || hotspotLast.lastAssemblyId.contains(root.lastParentAssemblyId)) continue;
                child.reactorCallId = counter.incrementAndGet();
                if (root != mainRoot) {
                    this.calculate(mainRoot, child.reactorCallId, child, child.id, true);
                }
                iterator.remove();
                if (!calculateMap.containsKey(hotspotLast)) {
                    ArrayList<Hotspot> value = new ArrayList<Hotspot>();
                    calculateMap.put(hotspotLast, value);
                    value.add(child);
                    continue;
                }
                calculateMap.get(hotspotLast).add(child);
            }
            catch (Exception e) {
                log.error("Can't transform current child");
            }
        }
        if (root.children.isEmpty()) {
            root.children = null;
        }
    }

    private Hotspot calculate(Hotspot hotspot, int id, Hotspot child, int methodId, boolean isClean) {
        if (hotspot.children == null) {
            return null;
        }
        for (Hotspot c : hotspot.children) {
            if (id == c.reactorCallId && methodId == c.id) {
                if (isClean) {
                    this.clean(hotspot, child);
                } else {
                    this.merge(hotspot, child);
                }
                return child;
            }
            Hotspot h = this.calculate(c, id, child, methodId, isClean);
            if (h == null) continue;
            if (isClean) {
                this.clean(hotspot, h);
            } else {
                this.merge(hotspot, h);
            }
            return h;
        }
        return null;
    }

    private void clean(Hotspot hotspot, Hotspot h) {
        hotspot.childTime -= h.totalTime;
        hotspot.totalTime -= h.totalTime;
        hotspot.childCount -= h.count + h.childCount;
        hotspot.childSuspensionTime -= h.suspensionTime + h.childSuspensionTime;
    }

    private void merge(Hotspot hotspot, Hotspot h) {
        if (hotspot.reactorStartTime != 0L && h.reactorStartTime != 0L) {
            hotspot.reactorStartTime = Math.min(h.reactorStartTime, hotspot.reactorStartTime);
        } else if (h.reactorStartTime != 0L) {
            if (hotspot.reactorDuration != 0) {
                hotspot.reactorStartTime = h.reactorStartTime;
            } else {
                hotspot.reactorStartTime = hotspot.startTime + hotspot.totalTime;
                hotspot.reactorLeastTime = hotspot.startTime + hotspot.totalTime;
            }
        }
        if (h.reactorStartTime != 0L) {
            int prevReactorDuration = hotspot.reactorDuration;
            h.reactorLeastTime = h.reactorStartTime + (long)h.reactorDuration;
            hotspot.reactorLeastTime = Math.max(hotspot.reactorLeastTime, h.reactorStartTime + (long)h.reactorDuration);
            hotspot.reactorDuration = (int)(hotspot.reactorLeastTime - hotspot.reactorStartTime);
            hotspot.childTime = hotspot.childTime - (long)prevReactorDuration + (long)hotspot.reactorDuration;
            hotspot.totalTime = hotspot.totalTime - (long)prevReactorDuration + (long)hotspot.reactorDuration;
        } else {
            hotspot.childTime += h.totalTime - (long)h.reactorDuration;
            hotspot.totalTime += h.totalTime - (long)h.reactorDuration;
        }
        hotspot.childCount += h.count + h.childCount;
        hotspot.childSuspensionTime += h.suspensionTime + h.childSuspensionTime;
        h.childTime -= (long)h.childSuspensionTime;
        h.totalTime -= (long)(h.childSuspensionTime + h.suspensionTime);
        if (hotspot.tags != null) {
            Iterator<HotspotTag> iterator = hotspot.tags.values().iterator();
            while (iterator.hasNext()) {
                HotspotTag value = iterator.next();
                if (value.assemblyId != h.lastParentAssemblyId) continue;
                iterator.remove();
                value.totalTime = h.totalTime + (long)h.reactorDuration;
                if (h.tags == null) {
                    h.tags = new HashMap<HotspotTag, HotspotTag>();
                }
                h.tags.put(value, value);
            }
        }
    }

    private Map<Long, Hotspot> getAllParents(Hotspot root) {
        HashMap<Long, Hotspot> stringListHashMap = new HashMap<Long, Hotspot>();
        if (root.children != null) {
            for (Hotspot child : root.children) {
                Map<Long, Hotspot> allParents;
                if (child.lastAssemblyId != null) {
                    for (Long aLong : child.lastAssemblyId) {
                        if (aLong == child.lastParentAssemblyId) continue;
                        stringListHashMap.put(aLong, child);
                    }
                }
                if ((allParents = this.getAllParents(child)).isEmpty()) continue;
                stringListHashMap.putAll(allParents);
            }
        }
        return stringListHashMap;
    }

    private Map<String, Integer> renderClobs(ClobValues clobs, JsonGenerator gen) throws IOException {
        HashMap<String, Integer> folder2id = new HashMap<String, Integer>();
        gen.writeRaw("var s={}; var x={}; var tc;\n");
        for (ClobValue clob : clobs.getClobs()) {
            Integer folderId = (Integer)folder2id.get(clob.dataFolderPath);
            if (folderId == null) {
                folderId = folder2id.size();
                folder2id.put(clob.dataFolderPath, folderId);
            }
            gen.writeRaw("tc=");
            gen.writeRaw(clob.folder.charAt(0));
            gen.writeRaw('[');
            gen.writeString(clob.offset + "/" + clob.fileIndex + "/" + folderId);
            gen.writeRaw("]=");
            CharSequence value = clob.value;
            boolean stringIsBig = false;
            if (value != null && value.length() >= this.paramTrimSizeForUI) {
                value = value.subSequence(0, this.paramTrimSizeForUI);
                stringIsBig = true;
            }
            if (stringIsBig) {
                gen.writeRaw("new String(");
            }
            gen.writeString(String.valueOf(value));
            if (stringIsBig) {
                gen.writeRaw(")");
            }
            gen.writeRaw(";\n");
            if (!stringIsBig) continue;
            gen.writeRaw("tc._0=");
            gen.writeNumber(clob.fileIndex);
            gen.writeRaw(";\n");
            gen.writeRaw("tc._1=");
            gen.writeNumber(clob.offset);
            gen.writeRaw(";\n");
            gen.writeRaw("tc._2=");
            gen.writeString(clob.folder);
            gen.writeRaw(";\n");
        }
        return folder2id;
    }

    private void renderTags(TagDictionary dict, JsonGenerator gen) throws IOException {
        ArrayList<String> tags = dict.getTags();
        BitSet requredIds = dict.getIds();
        int k = 0;
        gen.writeRaw("t=CT.tags;");
        int i = -1;
        while ((i = requredIds.nextSetBit(i + 1)) >= 0) {
            String tag = (String)tags.get(i);
            if (tag == null) continue;
            gen.writeRaw("t.a(");
            gen.writeNumber(i);
            gen.writeRaw(',');
            gen.writeString(tag);
            gen.writeRaw(");");
            if (++k != 10) continue;
            gen.writeRaw('\n');
            k = 0;
        }
        k = 0;
        for (ParameterInfoDto info : dict.getParamInfo().values()) {
            gen.writeRaw("t.b(");
            gen.writeString(info.name);
            gen.writeRaw(',');
            gen.writeRaw(info.list ? (char)'1' : '0');
            gen.writeRaw(',');
            gen.writeNumber(info.order);
            gen.writeRaw(',');
            gen.writeRaw(info.index ? (char)'1' : '0');
            gen.writeRaw(',');
            if (info.signatureFunction == null) {
                gen.writeString("");
            } else {
                gen.writeString(info.signatureFunction);
            }
            gen.writeRaw(");");
            if (++k != 10) continue;
            gen.writeRaw('\n');
            k = 0;
        }
        if (k != 0) {
            gen.writeRaw('\n');
        }
    }
}

