/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io.xlsx;

import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.qubership.profiler.configuration.ParameterInfoDto;
import org.qubership.profiler.io.Call;
import org.qubership.profiler.io.CallFilterer;
import org.qubership.profiler.io.xlsx.CallToXLSX;
import org.qubership.profiler.io.xlsx.ICallsToXLSXListener;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Profile;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Scope;
import org.qubership.profiler.shaded.org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Profile(value={"filestorage"})
public class CallsToXLSXListener
implements ICallsToXLSXListener {
    private static final int MAX_CELL_TEXT_LENGTH = 32760;
    String serverAddress;
    protected CallToXLSX formatter;
    private CallFilterer cf;

    public CallsToXLSXListener(String serverAddress, CallFilterer cf, OutputStream out) {
        this.serverAddress = serverAddress;
        this.cf = cf;
        this.formatter = new CallToXLSX(out);
        this.formatter.nextRow();
        this.formatter.addText("Link");
        this.formatter.addText("Start timestamp");
        this.formatter.addText("Duration");
        this.formatter.addText("CPU Time(ms)");
        this.formatter.addText("Suspended(ms)");
        this.formatter.addText("Queue(ms)");
        this.formatter.addText("Calls");
        this.formatter.addText("Transactions");
        this.formatter.addText("Disk Read (B)");
        this.formatter.addText("Disk Written (B)");
        this.formatter.addText("RAM (B)");
        this.formatter.addText("Logs generated");
        this.formatter.addText("Logs written (B)");
        this.formatter.addText("Net read (B)");
        this.formatter.addText("Net written (B)");
        this.createCellCaptions();
        this.formatter.addText("POD");
        this.formatter.addText("method");
        this.formatter.addText("params");
    }

    protected void createCellCaptions() {
    }

    protected void createAdditionalCells(String rootReference) {
    }

    private String encodeURL(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (Exception e) {
            return value;
        }
    }

    @Override
    public void processCalls(String rootReference, ArrayList<Call> calls, List<String> tags, Map<String, ParameterInfoDto> paramInfo, BitSet requiredIds) {
        if (calls.isEmpty()) {
            return;
        }
        String serverName = rootReference;
        if (rootReference.length() > 25 && rootReference.substring(rootReference.length() - 25).matches("[/\\\\]\\d{4}[/\\\\]\\d{2}[/\\\\]\\d{2}[/\\\\]\\d{13}")) {
            serverName = rootReference.substring(0, rootReference.length() - 25);
        }
        StringBuilder paramsText = new StringBuilder(32768);
        for (Call call : calls) {
            if (this.cf != null && !this.cf.filter(call)) continue;
            this.formatter.nextRow();
            this.formatter.addHyperlink(this.serverAddress + "/tree.html#params-trim-size=15000&f%5B_0%5D=" + this.encodeURL(rootReference.replace('\\', '/')) + "&i=0_" + call.traceFileIndex + "_" + call.bufferOffset + "_" + call.recordIndex + "_" + call.reactorFileIndex + "_" + call.reactorBufferOffset);
            this.formatter.addDate(new Date(call.time - (long)call.queueWaitDuration));
            this.formatter.addNumber(call.duration + call.queueWaitDuration);
            this.formatter.addNumber(call.cpuTime);
            this.formatter.addNumber(call.suspendDuration);
            this.formatter.addNumber(call.queueWaitDuration);
            this.formatter.addNumber(call.calls);
            this.formatter.addNumber(call.transactions);
            this.formatter.addNumber(call.fileRead);
            this.formatter.addNumber(call.fileWritten);
            this.formatter.addNumber(call.memoryUsed);
            this.formatter.addNumber(call.logsGenerated);
            this.formatter.addNumber(call.logsWritten);
            this.formatter.addNumber(call.netRead);
            this.formatter.addNumber(call.netWritten);
            this.createAdditionalCells(rootReference);
            this.formatter.addText(serverName);
            String title = tags.get(call.method);
            if (call.params == null) {
                this.formatter.addText(title);
                this.formatter.addEmpty();
                continue;
            }
            paramsText.setLength(0);
            StringBuilder workBuffer = paramsText;
            boolean firstParameter = true;
            for (Map.Entry<Integer, List<String>> entry : call.params.entrySet()) {
                String paramName = tags.get(entry.getKey());
                if ("profiler.title".equals(paramName) && entry.getValue().size() == 1) {
                    title = entry.getValue().get(0);
                    continue;
                }
                if (firstParameter) {
                    firstParameter = false;
                } else {
                    workBuffer = this.append(workBuffer, "; ");
                }
                workBuffer = this.append(workBuffer, paramName);
                workBuffer = this.append(workBuffer, "=");
                boolean firstValue = true;
                for (String value : entry.getValue()) {
                    if (firstValue) {
                        firstValue = false;
                    } else {
                        workBuffer = this.append(workBuffer, ",");
                    }
                    workBuffer = this.append(workBuffer, value);
                }
            }
            this.formatter.addText(title);
            this.formatter.addText(paramsText.toString());
        }
    }

    private StringBuilder append(StringBuilder sb, String text) {
        if (sb == null) {
            return null;
        }
        if (sb.length() + text.length() > 32760) {
            sb.append(text, 0, 32760 - sb.length()).append(" ...");
            return null;
        }
        sb.append(text);
        return sb;
    }

    @Override
    public void postProcess(String rootReference) {
    }

    @Override
    public void postProcess() {
        this.formatter.finish();
    }

    @Override
    public void processError(Throwable ex) {
        this.formatter.nextRow();
        this.formatter.addText(ex.toString());
    }
}

