/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.servlet;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.qubership.profiler.agent.Bootstrap;
import org.qubership.profiler.agent.DumperPlugin;
import org.qubership.profiler.agent.DumperPlugin_02;
import org.qubership.profiler.agent.DumperPlugin_08;
import org.qubership.profiler.agent.ProfilerTransformerPlugin;
import org.qubership.profiler.agent.ProfilerTransformerPlugin_01;
import org.qubership.profiler.agent.ReloadStatus;
import org.qubership.profiler.dump.DumpRootResolver;
import org.qubership.profiler.io.JSHelper;
import org.qubership.profiler.servlet.util.DumperStatusProvider;
import org.qubership.profiler.shaded.org.apache.commons.lang.math.NumberUtils;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;
import org.qubership.profiler.util.ThrowableHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigImpl {
    public static final Logger log = LoggerFactory.getLogger(ConfigImpl.class);
    public static final String CONFIG_FILTERS_FILE = "_config.filters.xml";
    public static final String CONFIG_FILTERS_OVERRIDE_FILE = "_config.filters.override.xml";

    void processConfigurationReload(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String configPath = request.getParameter("config");
        Throwable result = null;
        try {
            this.updateConfigPath(configPath);
            String now = request.getParameter("now");
            if (now != null && Boolean.valueOf(now).booleanValue()) {
                this.reloadConfig(null);
            }
        }
        catch (Throwable t) {
            result = t;
        }
        this.showReloadStatus(request, response, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConfigPath(String configPath) throws IOException {
        String currentConfig = this.getCurrentConfigFile();
        File config = new File(currentConfig);
        File configDir = config.getAbsoluteFile().getParentFile();
        File newConfig = new File(configDir, configPath);
        if (!newConfig.exists()) {
            throw new IOException("Unable to use " + configPath + " as new config file since it does not exist");
        }
        if (!newConfig.getCanonicalPath().startsWith(configDir.getCanonicalPath())) {
            throw new IllegalArgumentException("Access denied. The path is outside of config folder.");
        }
        File configFilters = new File(configDir, CONFIG_FILTERS_OVERRIDE_FILE);
        if (!configFilters.exists()) {
            configFilters = new File(configDir, CONFIG_FILTERS_FILE);
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        OutputStream out = null;
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(configFilters);
            Element rule = null;
            NodeList list = doc.getElementsByTagName("rule");
            if (list != null) {
                int len = list.getLength();
                for (int i = 0; i < len; ++i) {
                    Element el;
                    Node node = list.item(i);
                    if (!(node instanceof Element) || !"filter-rule".equals((el = (Element)node).getAttribute("id"))) continue;
                    rule = el;
                    break;
                }
            }
            if (rule == null) {
                throw new IllegalStateException("Unable to update " + configFilters.getAbsolutePath() + " file since rule with id of filter-rule was not found");
            }
            rule.setAttribute("src", configPath);
            TransformerFactory trf = TransformerFactory.newInstance();
            Transformer tr = trf.newTransformer();
            tr.setOutputProperty("indent", "yes");
            out = new BufferedOutputStream(new FileOutputStream(new File(configDir, CONFIG_FILTERS_OVERRIDE_FILE)));
            tr.transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (ParserConfigurationException e) {
            log.warn("Unable to parse file {}", (Object)configFilters.getAbsolutePath(), (Object)e);
        }
        catch (SAXException e) {
            log.warn("Unable to parse file {}", (Object)configFilters.getAbsolutePath(), (Object)e);
        }
        catch (IOException e) {
            log.warn("Unable to parse file {}", (Object)configFilters.getAbsolutePath(), (Object)e);
        }
        catch (TransformerConfigurationException e) {
            log.warn("Unable to write file {}", (Object)configFilters.getAbsolutePath(), (Object)e);
        }
        catch (TransformerException e) {
            log.warn("Unable to write file {}", (Object)configFilters.getAbsolutePath(), (Object)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String getCurrentFiletringConfig(String configPath) {
        File config = new File(configPath);
        File configDir = config.getAbsoluteFile().getParentFile();
        File configFilters = new File(configDir, CONFIG_FILTERS_OVERRIDE_FILE);
        if (!configFilters.exists()) {
            configFilters = new File(configDir, CONFIG_FILTERS_FILE);
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(configFilters);
            NodeList list = doc.getElementsByTagName("rule");
            if (list == null) {
                return "";
            }
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                Element el;
                Node node = list.item(i);
                if (!(node instanceof Element) || !"filter-rule".equals((el = (Element)node).getAttribute("id"))) continue;
                return el.getAttribute("src");
            }
        }
        catch (ParserConfigurationException e) {
            log.warn("Unable to parse file {}", (Object)configFilters.getAbsolutePath(), (Object)e);
        }
        catch (SAXException e) {
            log.warn("Unable to parse file {}", (Object)configFilters.getAbsolutePath(), (Object)e);
        }
        catch (IOException e) {
            log.warn("Unable to parse file {}", (Object)configFilters.getAbsolutePath(), (Object)e);
        }
        return "";
    }

    private String getCurrentConfigFile() {
        try {
            ProfilerTransformerPlugin_01 tr = this.getTransformer();
            ReloadStatus status = tr.getReloadStatus();
            return status.getConfigPath();
        }
        catch (Throwable t) {
            log.info("Unable to get config root. Looks like Profiler agent is not running", t);
            return DumpRootResolver.CONFIG_FILE;
        }
    }

    void showReloadStatus(HttpServletRequest request, HttpServletResponse response, Throwable overriden) throws ServletException, IOException {
        response.setContentType("application/x-javascript; charset=utf-8");
        PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "utf-8")), false);
        String id = request.getParameter("id");
        if (!NumberUtils.isDigits(id)) {
            out.print("alert('Wrong id passed to /config/reload_status');");
            out.flush();
            return;
        }
        out.print("dataReceived");
        out.print('(');
        out.print(id);
        out.print(", ");
        StringWriter sw = new StringWriter();
        if (overriden == null) {
            try {
                ProfilerTransformerPlugin_01 tr = this.getTransformer();
                ReloadStatus status = tr.getReloadStatus();
                sw.append('[');
                sw.append(Boolean.toString(status.isDone())).append(',');
                sw.append(Integer.toString(status.getTotalCount())).append(',');
                sw.append(Integer.toString(status.getSuccessCount())).append(',');
                sw.append(Integer.toString(status.getErrorCount())).append(",'");
                String configPath = status.getConfigPath();
                configPath = this.relativeToCWD(configPath);
                JSHelper.escapeJS(sw, configPath);
                sw.append("','");
                JSHelper.escapeJS(sw, this.getCurrentFiletringConfig(status.getConfigPath()));
                sw.append("','");
                JSHelper.escapeJS(sw, status.getMessage());
                sw.append("']");
            }
            catch (Throwable t) {
                overriden = t;
            }
        }
        if (overriden == null) {
            out.print(sw.toString());
        } else {
            String configPath = DumpRootResolver.CONFIG_FILE;
            out.print("[1,1,0,1,'");
            JSHelper.escapeJS(out, configPath);
            out.append("','");
            JSHelper.escapeJS(out, this.getCurrentFiletringConfig(configPath));
            out.print("','Reload failed: ");
            JSHelper.escapeJS(out, ThrowableHelper.throwableToString(overriden));
            out.print("']");
        }
        out.print(");");
        out.flush();
    }

    private String relativeToCWD(String path) {
        if (path != null) {
            String cwdPath;
            File cwd = new File(".").getAbsoluteFile();
            if (cwd != null) {
                cwd = cwd.getParentFile();
            }
            if (cwd != null && (cwdPath = cwd.getAbsolutePath()) != null && path.startsWith(cwdPath)) {
                path = path.substring(cwdPath.length() + 1);
            }
        }
        return path;
    }

    private void reloadConfig(String configPath) throws IOException, SAXException, ParserConfigurationException {
        ProfilerTransformerPlugin_01 transformer = this.getTransformer();
        if (transformer == null) {
            return;
        }
        transformer.reloadConfiguration(configPath);
    }

    public ProfilerTransformerPlugin_01 getTransformer() {
        ProfilerTransformerPlugin transformerPlugin = Bootstrap.getPlugin(ProfilerTransformerPlugin.class);
        if (transformerPlugin == null || !(transformerPlugin instanceof ProfilerTransformerPlugin_01)) {
            throw new IllegalStateException("Installed version of profiler does not support configuration reloading");
        }
        return (ProfilerTransformerPlugin_01)transformerPlugin;
    }

    private DumperPlugin_02 getDumper() {
        DumperPlugin dumperPlugin = Bootstrap.getPlugin(DumperPlugin.class);
        if (dumperPlugin == null || !(dumperPlugin instanceof DumperPlugin_02)) {
            throw new IllegalStateException("Installed version of dumper does not support on the fly management");
        }
        return (DumperPlugin_02)dumperPlugin;
    }

    void showDumperStatus(HttpServletRequest request, HttpServletResponse response, Throwable overriden) throws IOException {
        response.setContentType("application/x-javascript; charset=utf-8");
        PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "utf-8")), false);
        String callback = request.getParameter("callback");
        if (callback == null) {
            callback = "dataReceived";
        }
        callback = URLEncoder.encode(callback, "UTF-8");
        out.print(callback);
        out.print('(');
        out.print(URLEncoder.encode(request.getParameter("id"), "UTF-8"));
        out.print(", ");
        StringWriter sw = new StringWriter();
        if (overriden == null) {
            try {
                this.computeDumperStatus(sw);
            }
            catch (Throwable t) {
                overriden = t;
            }
        }
        if (overriden == null) {
            out.print(sw.toString());
        } else {
            out.print("['Unable to request dumper status: ");
            JSHelper.escapeJS(out, ThrowableHelper.throwableToString(overriden));
            out.print("']");
        }
        out.print(");");
        out.flush();
    }

    private void computeDumperStatus(StringWriter sw) {
        DumperStatusProvider dumper = DumperStatusProvider.INSTANCE;
        dumper.update();
        sw.append('[');
        sw.append(Boolean.toString(dumper.isStarted));
        sw.append(',');
        sw.append(Long.toString(dumper.activeTime));
        sw.append(',');
        sw.append(Integer.toString(dumper.numberOfRestarts));
        sw.append(',');
        sw.append(Long.toString(dumper.writeTime));
        sw.append(',');
        sw.append(Long.toString(dumper.writtenBytes));
        sw.append(',');
        sw.append(Long.toString(dumper.writtenRecords));
        sw.append(',');
        sw.append('\"');
        File root = dumper.currentRoot;
        if (root != null) {
            String rootPath = this.relativeToCWD(root.getAbsolutePath());
            try {
                JSHelper.escapeJS(sw, rootPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        sw.append('\"');
        sw.append(',');
        sw.append(Long.toString(dumper.cpuTime));
        sw.append(',');
        sw.append(Long.toString(dumper.bytesAllocated));
        sw.append(',');
        sw.append(Long.toString(dumper.fileRead));
        sw.append(',');
        sw.append(Long.toString(dumper.archiveSize));
        sw.append(']');
    }

    void stopDumper(HttpServletRequest request, HttpServletResponse response, Throwable overriden) throws IOException {
        try {
            DumperPlugin_02 dumper = this.getDumper();
            dumper.stop(true);
        }
        catch (Throwable t) {
            overriden = t;
        }
        this.showDumperStatus(request, response, overriden);
    }

    void startDumper(HttpServletRequest request, HttpServletResponse response, Throwable overriden) throws IOException {
        try {
            DumperPlugin_02 dumper = this.getDumper();
            dumper.start();
        }
        catch (Throwable t) {
            overriden = t;
        }
        this.showDumperStatus(request, response, overriden);
    }

    void rescanDumpFiles(HttpServletRequest request, HttpServletResponse response, Throwable overriden) throws IOException {
        try {
            DumperPlugin_02 dumper = this.getDumper();
            if (dumper instanceof DumperPlugin_08) {
                DumperPlugin_08 d = (DumperPlugin_08)dumper;
                d.forceRescanDumpDir();
            }
        }
        catch (Throwable t) {
            overriden = t;
        }
        this.showDumperStatus(request, response, overriden);
    }
}

