/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.servlet;

import java.io.File;
import java.util.logging.Level;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.qubership.profiler.audit.SessionAuditListener;
import org.qubership.profiler.configuration.PropertyFacade;
import org.qubership.profiler.dump.DumpRootResolver;
import org.qubership.profiler.shaded.ch.qos.logback.classic.BasicConfigurator;
import org.qubership.profiler.shaded.ch.qos.logback.classic.Logger;
import org.qubership.profiler.shaded.ch.qos.logback.classic.LoggerContext;
import org.qubership.profiler.shaded.ch.qos.logback.classic.joran.JoranConfigurator;
import org.qubership.profiler.shaded.ch.qos.logback.core.joran.spi.JoranException;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;

public class LogbackInitializer
implements ServletContextListener {
    private static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger(LogbackInitializer.class.getName());
    private static boolean logbackInitialized = false;

    @Override
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        LogbackInitializer.initLogback();
    }

    @Override
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        LoggerFactory.getLogger(SessionAuditListener.class).info("Audit log stopped");
    }

    public static void initLogback() {
        block7: {
            if (logbackInitialized) {
                return;
            }
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            String logbackXmlPath = PropertyFacade.getProperty("profiler.web.log.config", null);
            File logFile = new File(new File(DumpRootResolver.PROFILER_HOME), "config/logback-web.xml");
            if (logbackXmlPath == null && logFile.exists()) {
                logbackXmlPath = logFile.getAbsolutePath();
            }
            if (logbackXmlPath == null) {
                logger.warning("Profiler: unable to find " + logFile.getAbsolutePath() + " configuration file, you might specify its location via execution-statistics-collector.web.log.config property");
            }
            try {
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext(lc);
                lc.reset();
                if (logbackXmlPath != null) {
                    logger.fine("Profiler: reading logback configuration from " + logbackXmlPath);
                    configurator.doConfigure(logbackXmlPath);
                } else {
                    logger.fine("Profiler: trying to find /WEB-INF/logback-web.xml in classpath");
                    configurator.doConfigure(LogbackInitializer.class.getResourceAsStream("/WEB-INF/logback-web.xml"));
                }
            }
            catch (JoranException je) {
                logger.log(Level.WARNING, "Unable to load logging configuration from " + logbackXmlPath, je);
                new BasicConfigurator().configure(lc);
                Logger root = lc.getLogger("ROOT");
                String logLevel = System.getProperty("esc.web.log.level");
                logger.warning("logLevel 2 = " + logLevel);
                if (logLevel == null) break block7;
                org.qubership.profiler.shaded.ch.qos.logback.classic.Level newLevel = org.qubership.profiler.shaded.ch.qos.logback.classic.Level.toLevel(logLevel);
                logger.fine("Profiler: activating " + newLevel + " log level for the web application");
                root.setLevel(newLevel);
            }
        }
        LoggerFactory.getLogger(SessionAuditListener.class).info("Audit log started");
        logbackInitialized = true;
    }
}

