/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.ch.qos.logback.access.pattern;

import java.util.List;
import java.util.TimeZone;
import org.qubership.profiler.shaded.ch.qos.logback.access.pattern.AccessConverter;
import org.qubership.profiler.shaded.ch.qos.logback.access.spi.IAccessEvent;
import org.qubership.profiler.shaded.ch.qos.logback.core.util.CachingDateFormatter;

public class DateConverter
extends AccessConverter {
    CachingDateFormatter cachingDateFormatter = null;

    @Override
    public void start() {
        String datePattern = this.getFirstOption();
        if (datePattern == null) {
            datePattern = "dd/MMM/yyyy:HH:mm:ss Z";
        }
        if (datePattern.equals("ISO8601")) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        try {
            this.cachingDateFormatter = new CachingDateFormatter(datePattern);
        }
        catch (IllegalArgumentException e) {
            this.addWarn("Could not instantiate SimpleDateFormat with pattern " + datePattern, e);
            this.addWarn("Defaulting to  dd/MMM/yyyy:HH:mm:ss Z");
            this.cachingDateFormatter = new CachingDateFormatter("dd/MMM/yyyy:HH:mm:ss Z");
        }
        List<String> optionList = this.getOptionList();
        if (optionList != null && optionList.size() > 1) {
            TimeZone tz = TimeZone.getTimeZone(optionList.get(1));
            this.cachingDateFormatter.setTimeZone(tz);
        }
    }

    @Override
    public String convert(IAccessEvent accessEvent) {
        long timestamp = accessEvent.getTimeStamp();
        return this.cachingDateFormatter.format(timestamp);
    }
}

