/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.com.github.ziplet.filter.compression;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingFilterContext;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingServletInputStream;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingStreamFactory;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.EmptyEnumeration;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.IteratorEnumeration;

final class CompressedHttpServletRequest
extends HttpServletRequestWrapper {
    private final ServletRequest httpRequest;
    private final CompressingStreamFactory compressingStreamFactory;
    private final CompressingFilterContext context;
    private CompressingServletInputStream compressedSIS;
    private BufferedReader bufferedReader;
    private boolean isGetInputStreamCalled;
    private boolean isGetReaderCalled;

    CompressedHttpServletRequest(HttpServletRequest httpRequest, CompressingStreamFactory compressingStreamFactory, CompressingFilterContext context) {
        super(httpRequest);
        this.httpRequest = httpRequest;
        this.compressingStreamFactory = compressingStreamFactory;
        this.context = context;
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        if (this.isGetReaderCalled) {
            throw new IllegalStateException("getReader() has already been called");
        }
        this.isGetInputStreamCalled = true;
        return this.getCompressingServletInputStream();
    }

    @Override
    public BufferedReader getReader() throws IOException {
        if (this.isGetInputStreamCalled) {
            throw new IllegalStateException("getInputStream() has already been called");
        }
        this.isGetReaderCalled = true;
        if (this.bufferedReader == null) {
            this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)this.getCompressingServletInputStream(), this.getCharacterEncoding()));
        }
        return this.bufferedReader;
    }

    private CompressingServletInputStream getCompressingServletInputStream() throws IOException {
        if (this.compressedSIS == null) {
            this.compressedSIS = new CompressingServletInputStream(this.httpRequest.getInputStream(), this.compressingStreamFactory, this.context);
        }
        return this.compressedSIS;
    }

    private static boolean isFilteredHeader(String headerName) {
        return "Content-Encoding".equalsIgnoreCase(headerName) || "Accept-Encoding".equalsIgnoreCase(headerName);
    }

    @Override
    public String getHeader(String header) {
        return CompressedHttpServletRequest.isFilteredHeader(header) ? null : super.getHeader(header);
    }

    public Enumeration<?> getHeaders(String header) {
        Enumeration<String> original = super.getHeaders(header);
        if (original == null) {
            return null;
        }
        return CompressedHttpServletRequest.isFilteredHeader(header) ? EmptyEnumeration.getInstance() : original;
    }

    @Override
    public long getDateHeader(String header) {
        return CompressedHttpServletRequest.isFilteredHeader(header) ? -1L : super.getDateHeader(header);
    }

    @Override
    public int getIntHeader(String header) {
        return CompressedHttpServletRequest.isFilteredHeader(header) ? -1 : super.getIntHeader(header);
    }

    public Enumeration<?> getHeaderNames() {
        Enumeration<String> original = super.getHeaderNames();
        if (original == null) {
            return null;
        }
        ArrayList<String> headerNames = new ArrayList<String>();
        while (original.hasMoreElements()) {
            String headerName = original.nextElement();
            if (CompressedHttpServletRequest.isFilteredHeader(headerName)) continue;
            headerNames.add(headerName);
        }
        return new IteratorEnumeration(headerNames.iterator());
    }

    public String toString() {
        return "CompressedHttpServletRequest";
    }
}

