/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.com.github.ziplet.filter.compression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.statistics.CompressingFilterEmptyStats;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.statistics.CompressingFilterStats;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.statistics.CompressingFilterStatsImpl;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;

final class CompressingFilterContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressingFilterContext.class);
    private static final int DEFAULT_COMPRESSION_THRESHOLD = 1024;
    private static final Pattern COMMA = Pattern.compile(",");
    private final boolean debug;
    private final int compressionThreshold;
    private final ServletContext servletContext;
    private CompressingFilterStats stats;
    private final boolean includeContentTypes;
    private final Collection<String> contentTypes;
    private final boolean includePathPatterns;
    private final Collection<Pattern> pathPatterns;
    private final boolean includeUserAgentPatterns;
    private final Collection<Pattern> userAgentPatterns;
    private final Collection<Pattern> noVaryHeaderPatterns;

    CompressingFilterContext(FilterConfig filterConfig, CompressingFilterStats stats) throws ServletException {
        this(filterConfig);
        this.setCompressingFilterStats(stats);
    }

    CompressingFilterContext(FilterConfig filterConfig) throws ServletException {
        assert (filterConfig != null);
        this.debug = CompressingFilterContext.readBooleanValue(filterConfig, "debug");
        LOGGER.debug("Debug logging statements are enabled");
        this.compressionThreshold = CompressingFilterContext.readCompressionThresholdValue(filterConfig);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using compressing threshold: " + this.compressionThreshold);
        }
        this.servletContext = filterConfig.getServletContext();
        assert (this.servletContext != null);
        if (CompressingFilterContext.readBooleanValue(filterConfig, "statsEnabled")) {
            this.stats = new CompressingFilterStatsImpl();
            this.ensureStatsInContext();
            LOGGER.debug("Stats are enabled");
        } else {
            this.stats = new CompressingFilterEmptyStats();
            LOGGER.debug("Stats are disabled");
        }
        String noVaryHeaderString = filterConfig.getInitParameter("noVaryHeaderPatterns");
        this.noVaryHeaderPatterns = noVaryHeaderString != null ? CompressingFilterContext.parsePatterns(noVaryHeaderString) : Collections.emptyList();
        String includeContentTypesString = filterConfig.getInitParameter("includeContentTypes");
        String excludeContentTypesString = filterConfig.getInitParameter("excludeContentTypes");
        if (includeContentTypesString != null && excludeContentTypesString != null) {
            throw new IllegalArgumentException("Can't specify both includeContentTypes and excludeContentTypes");
        }
        if (includeContentTypesString == null) {
            this.includeContentTypes = false;
            this.contentTypes = CompressingFilterContext.parseContentTypes(excludeContentTypesString);
        } else {
            this.includeContentTypes = true;
            this.contentTypes = CompressingFilterContext.parseContentTypes(includeContentTypesString);
        }
        if (!this.contentTypes.isEmpty()) {
            LOGGER.debug("Filter will " + (this.includeContentTypes ? "include" : "exclude") + " only these content types: " + this.contentTypes);
        }
        String includePathPatternsString = filterConfig.getInitParameter("includePathPatterns");
        String excludePathPatternsString = filterConfig.getInitParameter("excludePathPatterns");
        if (includePathPatternsString != null && excludePathPatternsString != null) {
            throw new IllegalArgumentException("Can't specify both includePathPatterns and excludePathPatterns");
        }
        if (includePathPatternsString == null) {
            this.includePathPatterns = false;
            this.pathPatterns = CompressingFilterContext.parsePatterns(excludePathPatternsString);
        } else {
            this.includePathPatterns = true;
            this.pathPatterns = CompressingFilterContext.parsePatterns(includePathPatternsString);
        }
        if (!this.pathPatterns.isEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Filter will " + (this.includePathPatterns ? "include" : "exclude") + " only these file patterns: " + this.pathPatterns);
        }
        String includeUserAgentPatternsString = filterConfig.getInitParameter("includeUserAgentPatterns");
        String excludeUserAgentPatternsString = filterConfig.getInitParameter("excludeUserAgentPatterns");
        if (includeUserAgentPatternsString != null && excludeUserAgentPatternsString != null) {
            throw new IllegalArgumentException("Can't specify both includeUserAgentPatterns and excludeUserAgentPatterns");
        }
        if (includeUserAgentPatternsString == null) {
            this.includeUserAgentPatterns = false;
            this.userAgentPatterns = CompressingFilterContext.parsePatterns(excludeUserAgentPatternsString);
        } else {
            this.includeUserAgentPatterns = true;
            this.userAgentPatterns = CompressingFilterContext.parsePatterns(includeUserAgentPatternsString);
        }
        if (!this.userAgentPatterns.isEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Filter will " + (this.includeUserAgentPatterns ? "include" : "exclude") + " only these User-Agent patterns: " + this.userAgentPatterns);
        }
    }

    public void setCompressingFilterStats(CompressingFilterStats stats) {
        this.stats = stats;
    }

    boolean isDebug() {
        return this.debug;
    }

    int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public CompressingFilterStats getStats() {
        if (this.stats == null) {
            throw new IllegalStateException("Stats are not enabled");
        }
        this.ensureStatsInContext();
        return this.stats;
    }

    boolean isIncludeContentTypes() {
        return this.includeContentTypes;
    }

    Collection<String> getContentTypes() {
        return this.contentTypes;
    }

    boolean isIncludePathPatterns() {
        return this.includePathPatterns;
    }

    Iterable<Pattern> getPathPatterns() {
        return this.pathPatterns;
    }

    boolean isIncludeUserAgentPatterns() {
        return this.includeUserAgentPatterns;
    }

    Iterable<Pattern> getUserAgentPatterns() {
        return this.userAgentPatterns;
    }

    Iterable<Pattern> getNoVaryHeaderPatterns() {
        return this.noVaryHeaderPatterns;
    }

    public String toString() {
        return "CompressingFilterContext";
    }

    private void ensureStatsInContext() {
        assert (this.servletContext != null);
        if (this.servletContext.getAttribute(this.stats.getStatsKey()) == null) {
            this.servletContext.setAttribute(this.stats.getStatsKey(), this.stats);
        }
    }

    private static boolean readBooleanValue(FilterConfig filterConfig, String parameter) {
        return Boolean.valueOf(filterConfig.getInitParameter(parameter));
    }

    private static int readCompressionThresholdValue(FilterConfig filterConfig) throws ServletException {
        int value;
        String compressionThresholdString = filterConfig.getInitParameter("compressionThreshold");
        if (compressionThresholdString != null) {
            try {
                value = Integer.parseInt(compressionThresholdString);
            }
            catch (NumberFormatException nfe) {
                throw new ServletException("Invalid compression threshold: " + compressionThresholdString, nfe);
            }
            if (value < 0) {
                throw new ServletException("Compression threshold cannot be negative");
            }
        } else {
            value = 1024;
        }
        return value;
    }

    private static Collection<String> parseContentTypes(String contentTypesString) {
        if (contentTypesString == null) {
            return Collections.emptyList();
        }
        ArrayList<String> contentTypes = new ArrayList<String>(5);
        for (String contentType : COMMA.split(contentTypesString)) {
            if (contentType.length() <= 0) continue;
            contentTypes.add(contentType);
        }
        return Collections.unmodifiableList(contentTypes);
    }

    private static Collection<Pattern> parsePatterns(String patternsString) {
        if (patternsString == null) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(5);
        for (String pattern : COMMA.split(patternsString)) {
            if (pattern.length() <= 0) continue;
            patterns.add(Pattern.compile(pattern));
        }
        return Collections.unmodifiableList(patterns);
    }
}

