/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.com.github.ziplet.filter.compression;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingFilter;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingFilterContext;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingServletOutputStream;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingStreamFactory;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;

final class CompressingHttpServletResponse
extends HttpServletResponseWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressingHttpServletResponse.class);
    static final String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    private static final String CACHE_CONTROL_HEADER = "Cache-Control";
    static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String ETAG_HEADER = "ETag";
    private static final String X_COMPRESSED_BY_HEADER = "X-Compressed-By";
    private static final String[] UNALLOWED_HEADERS = new String[]{"Cache-Control", "Content-Length", "Content-Encoding", "ETag", "X-Compressed-By"};
    private static final String COMPRESSED_BY_VALUE = CompressingFilter.VERSION_STRING;
    private final HttpServletResponse httpResponse;
    private final CompressingFilterContext context;
    private final String compressedContentEncoding;
    private final CompressingStreamFactory compressingStreamFactory;
    private CompressingServletOutputStream compressingSOS;
    private PrintWriter printWriter;
    private boolean isGetOutputStreamCalled;
    private boolean isGetWriterCalled;
    private boolean compressing;
    private long savedContentLength;
    private boolean savedContentLengthSet;
    private String savedContentEncoding;
    private String savedETag;
    private boolean contentTypeOK;
    private boolean noTransformSet;

    CompressingHttpServletResponse(HttpServletResponse httpResponse, CompressingStreamFactory compressingStreamFactory, String contentEncoding, CompressingFilterContext context) {
        super(httpResponse);
        this.httpResponse = httpResponse;
        this.compressedContentEncoding = contentEncoding;
        this.compressing = false;
        this.compressingStreamFactory = compressingStreamFactory;
        this.context = context;
        this.contentTypeOK = true;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.isGetWriterCalled) {
            throw new IllegalStateException("getWriter() has already been called");
        }
        this.isGetOutputStreamCalled = true;
        return this.getCompressingServletOutputStream();
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.isGetOutputStreamCalled) {
            throw new IllegalStateException("getCompressingOutputStream() has already been called");
        }
        this.isGetWriterCalled = true;
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)this.getCompressingServletOutputStream(), this.getCharacterEncoding()), true);
        }
        return this.printWriter;
    }

    @Override
    public void addHeader(String name, String value) {
        if (CACHE_CONTROL_HEADER.equalsIgnoreCase(name)) {
            this.httpResponse.addHeader(CACHE_CONTROL_HEADER, value);
            if (value.contains("no-transform")) {
                LOGGER.debug("Aborting compression due to no-transform directive");
                this.noTransformSet = true;
                this.maybeAbortCompression();
            }
        } else if (CONTENT_ENCODING_HEADER.equalsIgnoreCase(name)) {
            this.savedContentEncoding = value;
            if (!CompressingHttpServletResponse.isCompressableEncoding(value)) {
                this.maybeAbortCompression();
            }
        } else if (CONTENT_LENGTH_HEADER.equalsIgnoreCase(name)) {
            this.setContentLengthLong(Long.parseLong(value));
        } else if (CONTENT_TYPE_HEADER.equalsIgnoreCase(name)) {
            this.setContentType(value);
        } else if (ETAG_HEADER.equalsIgnoreCase(name)) {
            this.savedETag = value;
            this.setETagHeader();
        } else if (this.isAllowedHeader(name)) {
            this.httpResponse.addHeader(name, value);
        }
    }

    @Override
    public void addIntHeader(String name, int value) {
        if (CONTENT_LENGTH_HEADER.equalsIgnoreCase(name)) {
            this.setContentLength(value);
        } else if (ETAG_HEADER.equalsIgnoreCase(name)) {
            this.savedETag = String.valueOf(value);
            this.setETagHeader();
        } else if (this.isAllowedHeader(name)) {
            this.httpResponse.addIntHeader(name, value);
        }
    }

    @Override
    public void addDateHeader(String name, long value) {
        if (this.isAllowedHeader(name)) {
            this.httpResponse.addDateHeader(name, value);
        }
    }

    @Override
    public void setHeader(String name, String value) {
        if (CACHE_CONTROL_HEADER.equalsIgnoreCase(name)) {
            this.httpResponse.setHeader(CACHE_CONTROL_HEADER, value);
            if (value.contains("no-transform")) {
                LOGGER.debug("Aborting compression due to no-transform directive");
                this.noTransformSet = true;
                this.maybeAbortCompression();
            }
        } else if (CONTENT_ENCODING_HEADER.equalsIgnoreCase(name)) {
            this.savedContentEncoding = value;
            if (!CompressingHttpServletResponse.isCompressableEncoding(value)) {
                this.maybeAbortCompression();
            }
        } else if (CONTENT_LENGTH_HEADER.equalsIgnoreCase(name)) {
            this.setContentLengthLong(Long.parseLong(value));
        } else if (CONTENT_TYPE_HEADER.equalsIgnoreCase(name)) {
            this.setContentType(value);
        } else if (ETAG_HEADER.equalsIgnoreCase(name)) {
            this.savedETag = value;
            this.setETagHeader();
        } else if (this.isAllowedHeader(name)) {
            this.httpResponse.setHeader(name, value);
        }
    }

    private void maybeAbortCompression() {
        if (this.compressingSOS != null) {
            try {
                this.compressingSOS.abortCompression();
            }
            catch (IOException ioe) {
                LOGGER.info("Unexpected error while aborting compression", ioe);
            }
        }
    }

    private void setETagHeader() {
        if (this.savedETag != null) {
            if (this.compressing) {
                this.httpResponse.setHeader(ETAG_HEADER, this.savedETag + '-' + this.compressedContentEncoding);
            } else {
                this.httpResponse.setHeader(ETAG_HEADER, this.savedETag);
            }
        }
    }

    @Override
    public void setIntHeader(String name, int value) {
        if (CONTENT_LENGTH_HEADER.equalsIgnoreCase(name)) {
            this.setContentLength(value);
        } else if (ETAG_HEADER.equalsIgnoreCase(name)) {
            this.savedETag = String.valueOf(value);
            this.setETagHeader();
        } else if (this.isAllowedHeader(name)) {
            this.httpResponse.setIntHeader(name, value);
        }
    }

    @Override
    public void setDateHeader(String name, long value) {
        if (this.isAllowedHeader(name)) {
            this.httpResponse.setDateHeader(name, value);
        }
    }

    @Override
    public void flushBuffer() {
        this.flushWriter();
        if (this.compressingSOS != null) {
            this.compressingSOS.flush();
        }
    }

    @Override
    public void reset() {
        this.flushWriter();
        if (this.compressingSOS != null) {
            this.compressingSOS.reset();
        }
        this.httpResponse.reset();
        if (this.compressing) {
            this.setCompressionResponseHeaders();
        } else {
            this.setNonCompressionResponseHeaders();
        }
    }

    @Override
    public void resetBuffer() {
        this.flushWriter();
        if (this.compressingSOS != null) {
            this.compressingSOS.reset();
        }
        this.httpResponse.resetBuffer();
    }

    @Override
    public void setContentLength(int contentLength) {
        this.setContentLengthLong(contentLength);
    }

    public void setContentLengthLong(long contentLength) {
        if (this.compressing) {
            LOGGER.debug("Ignoring application-specified content length since response is compressed");
        } else {
            this.savedContentLength = contentLength;
            this.savedContentLengthSet = true;
            LOGGER.debug("Saving application-specified content length for later: " + contentLength);
            if (this.compressingSOS != null && this.compressingSOS.isAborted()) {
                this.httpResponse.setHeader(CONTENT_LENGTH_HEADER, String.valueOf(contentLength));
            }
        }
    }

    @Override
    public void setContentType(String contentType) {
        this.contentTypeOK = this.isCompressableContentType(contentType);
        this.httpResponse.setContentType(contentType);
        if (!this.contentTypeOK && this.compressingSOS != null) {
            LOGGER.debug("Aborting compression since Content-Type is excluded: " + contentType);
            this.maybeAbortCompression();
        }
    }

    public String toString() {
        return "CompressingHttpServletResponse[compressing: " + this.compressing + ']';
    }

    boolean isCompressing() {
        return this.compressing;
    }

    void close() throws IOException {
        if (this.compressingSOS != null && !this.compressingSOS.isClosed()) {
            this.compressingSOS.close();
        }
    }

    private void setCompressionResponseHeaders() {
        LOGGER.debug("Setting compression-related headers");
        String fullContentEncodingHeader = this.savedContentEncoding == null ? this.compressedContentEncoding : this.savedContentEncoding + ',' + this.compressedContentEncoding;
        this.httpResponse.setHeader(CONTENT_ENCODING_HEADER, fullContentEncodingHeader);
        this.setETagHeader();
        if (this.context.isDebug()) {
            this.httpResponse.setHeader(X_COMPRESSED_BY_HEADER, COMPRESSED_BY_VALUE);
        }
    }

    private void setNonCompressionResponseHeaders() {
        if (this.savedContentLengthSet) {
            this.httpResponse.setHeader(CONTENT_LENGTH_HEADER, String.valueOf(this.savedContentLength));
        }
        if (this.savedContentEncoding != null) {
            this.httpResponse.setHeader(CONTENT_ENCODING_HEADER, this.savedContentEncoding);
        }
    }

    void rawStreamCommitted() {
        assert (!this.compressing);
        LOGGER.debug("Committing response without compression");
        this.setNonCompressionResponseHeaders();
    }

    void switchToCompression() {
        assert (!this.compressing);
        LOGGER.debug("Switching to compression in the response");
        this.compressing = true;
        this.setCompressionResponseHeaders();
    }

    private boolean isAllowedHeader(String header) {
        boolean unallowed;
        boolean bl = unallowed = header != null && CompressingHttpServletResponse.equalsIgnoreCaseAny(header, UNALLOWED_HEADERS);
        if (unallowed && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Header '" + header + "' cannot be set by application");
        }
        return !unallowed;
    }

    private static boolean equalsIgnoreCaseAny(String a, String ... others) {
        for (String other : others) {
            if (!a.equalsIgnoreCase(other)) continue;
            return true;
        }
        return false;
    }

    private void flushWriter() {
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    private boolean isCompressableContentType(String contentType) {
        String contentTypeOnly = contentType;
        if (contentType != null) {
            int semicolonIndex = contentType.indexOf(59);
            if (semicolonIndex >= 0) {
                contentTypeOnly = contentType.substring(0, semicolonIndex);
            }
        } else {
            return true;
        }
        for (String compressionEncoding : CompressingStreamFactory.ALL_COMPRESSION_ENCODINGS) {
            if (!contentTypeOnly.contains(compressionEncoding)) continue;
            return false;
        }
        boolean isContained = this.context.getContentTypes().contains(contentTypeOnly);
        return this.context.isIncludeContentTypes() ? isContained : !isContained;
    }

    private static boolean isCompressableEncoding(String encoding) {
        if (encoding == null) {
            return true;
        }
        for (String compressionEncoding : CompressingStreamFactory.ALL_COMPRESSION_ENCODINGS) {
            if (!encoding.equals(compressionEncoding)) continue;
            return false;
        }
        return true;
    }

    private CompressingServletOutputStream getCompressingServletOutputStream() throws IOException {
        if (this.compressingSOS == null) {
            this.compressingSOS = new CompressingServletOutputStream(this.httpResponse.getOutputStream(), this.compressingStreamFactory, this, this.context);
        }
        if (!this.compressingSOS.isClosed() && this.mustNotCompress()) {
            this.compressingSOS.abortCompression();
        }
        return this.compressingSOS;
    }

    private boolean mustNotCompress() {
        if (!this.contentTypeOK) {
            LOGGER.debug("Will not compress since configuration excludes this content type");
            return true;
        }
        if (this.savedContentLengthSet && this.savedContentLength < (long)this.context.getCompressionThreshold()) {
            LOGGER.debug("Will not compress since page has set a content length which is less than the compression threshold: " + this.savedContentLength);
            return true;
        }
        if (this.noTransformSet) {
            LOGGER.debug("Will not compress since no-transform was specified");
            return true;
        }
        return !CompressingHttpServletResponse.isCompressableEncoding(this.savedContentEncoding);
    }
}

