/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.com.github.ziplet.filter.compression;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingFilterContext;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingStreamFactory;

final class CompressingServletInputStream
extends ServletInputStream {
    private final InputStream compressingStream;
    private boolean closed;

    CompressingServletInputStream(InputStream rawStream, CompressingStreamFactory compressingStreamFactory, CompressingFilterContext context) throws IOException {
        this.compressingStream = compressingStreamFactory.getCompressingStream(rawStream, context).getCompressingInputStream();
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        return this.compressingStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkClosed();
        return this.compressingStream.read(b);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        this.checkClosed();
        return this.compressingStream.read(b, offset, length);
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkClosed();
        return this.compressingStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.checkClosed();
        return this.compressingStream.available();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.compressingStream.close();
            this.closed = true;
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.checkClosed();
        this.compressingStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.checkClosed();
        this.compressingStream.reset();
    }

    @Override
    public boolean markSupported() {
        this.checkClosed();
        return this.compressingStream.markSupported();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Stream is already closed");
        }
    }

    public String toString() {
        return "CompressingServletInputStream";
    }
}

