/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.com.github.ziplet.filter.compression;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingFilterContext;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingHttpServletResponse;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingStreamFactory;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.ThresholdOutputStream;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;

final class CompressingServletOutputStream
extends ServletOutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressingServletOutputStream.class);
    private final OutputStream rawStream;
    private final CompressingStreamFactory compressingStreamFactory;
    private final CompressingHttpServletResponse compressingResponse;
    private final CompressingFilterContext context;
    private ThresholdOutputStream thresholdOutputStream;
    private boolean closed;
    private boolean aborted;

    CompressingServletOutputStream(OutputStream rawStream, CompressingStreamFactory compressingStreamFactory, CompressingHttpServletResponse compressingResponse, CompressingFilterContext context) {
        this.rawStream = rawStream;
        this.compressingStreamFactory = compressingStreamFactory;
        this.compressingResponse = compressingResponse;
        this.context = context;
        this.closed = false;
        this.aborted = false;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkClosed();
        this.checkWriteState();
        assert (this.thresholdOutputStream != null);
        this.thresholdOutputStream.write(b);
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        this.checkClosed();
        this.checkWriteState();
        assert (this.thresholdOutputStream != null);
        this.thresholdOutputStream.write(b, offset, length);
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        this.checkWriteState();
        assert (this.thresholdOutputStream != null);
        this.thresholdOutputStream.write(b);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.compressingResponse.flushBuffer();
            this.closed = true;
            if (this.thresholdOutputStream == null) {
                this.compressingResponse.rawStreamCommitted();
                this.rawStream.close();
            } else {
                this.thresholdOutputStream.close();
            }
        }
    }

    public String toString() {
        return "CompressingServletOutputStream";
    }

    boolean isClosed() {
        return this.closed;
    }

    void reset() {
        if (this.thresholdOutputStream != null) {
            this.thresholdOutputStream.reset();
        }
    }

    void engageCompression() throws IOException {
        this.checkWriteState();
        this.thresholdOutputStream.switchToOutputStream2();
    }

    void abortCompression() throws IOException {
        assert (this.thresholdOutputStream == null);
        this.checkWriteState();
        this.thresholdOutputStream.forceOutputStream1();
        this.aborted = true;
    }

    boolean isAborted() {
        return this.aborted;
    }

    private void checkWriteState() {
        if (this.thresholdOutputStream == null) {
            this.thresholdOutputStream = new ThresholdOutputStream(this.rawStream, this.compressingStreamFactory, this.context, new ResponseBufferCommitmentCallback(this.compressingResponse));
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is already closed");
        }
    }

    private static final class ResponseBufferCommitmentCallback
    implements ThresholdOutputStream.BufferCommitmentCallback {
        private final CompressingHttpServletResponse response;

        private ResponseBufferCommitmentCallback(CompressingHttpServletResponse response) {
            assert (response != null);
            this.response = response;
        }

        @Override
        public void rawStreamCommitted() {
            this.response.rawStreamCommitted();
        }

        @Override
        public void compressingStreamCommitted() {
            this.response.switchToCompression();
        }

        public String toString() {
            return "ResponseBufferCommitmentCallback";
        }
    }
}

