/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.com.github.ziplet.filter.compression;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingFilterContext;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingInputStream;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingOutputStream;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.StatsField;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.StatsInputStream;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.StatsOutputStream;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.statistics.CompressingFilterStats;

abstract class CompressingStreamFactory {
    private static final CompressingStreamFactory GZIP_CSF = new GZIPCompressingStreamFactory();
    private static final CompressingStreamFactory ZIP_CSF = new ZipCompressingStreamFactory();
    private static final CompressingStreamFactory DEFLATE_CSF = new DeflateCompressingStreamFactory();
    static final String NO_ENCODING = "identity";
    private static final String GZIP_ENCODING = "gzip";
    private static final String X_GZIP_ENCODING = "x-gzip";
    private static final String DEFLATE_ENCODING = "deflate";
    private static final String COMPRESS_ENCODING = "compress";
    private static final String X_COMPRESS_ENCODING = "x-compress";
    static final String[] ALL_COMPRESSION_ENCODINGS = new String[]{"gzip", "deflate", "compress", "x-gzip", "x-compress"};
    private static final String ANY_ENCODING = "*";
    private static final List<String> supportedEncodings;
    private static final Map<String, String> bestEncodingCache;
    private static final Map<String, CompressingStreamFactory> factoryMap;
    private static final Pattern COMMA;

    CompressingStreamFactory() {
    }

    abstract CompressingOutputStream getCompressingStream(OutputStream var1, CompressingFilterContext var2) throws IOException;

    abstract CompressingInputStream getCompressingStream(InputStream var1, CompressingFilterContext var2) throws IOException;

    private static OutputStream maybeWrapStatsOutputStream(OutputStream outputStream, CompressingFilterContext context, StatsField field) {
        assert (outputStream != null);
        CompressingFilterStats stats = context.getStats();
        StatsOutputStream result = new StatsOutputStream(outputStream, stats, field);
        return result;
    }

    private static InputStream maybeWrapStatsInputStream(InputStream inputStream, CompressingFilterContext context, StatsField field) {
        assert (inputStream != null);
        CompressingFilterStats stats = context.getStats();
        StatsInputStream result = new StatsInputStream(inputStream, stats, field);
        return result;
    }

    private static boolean isSupportedResponseContentEncoding(String contentEncoding) {
        return NO_ENCODING.equals(contentEncoding) || factoryMap.containsKey(contentEncoding);
    }

    static boolean isSupportedRequestContentEncoding(String contentEncoding) {
        return NO_ENCODING.equals(contentEncoding) || factoryMap.containsKey(contentEncoding);
    }

    static CompressingStreamFactory getFactoryForContentEncoding(String contentEncoding) {
        assert (factoryMap.containsKey(contentEncoding));
        return factoryMap.get(contentEncoding);
    }

    static String getBestContentEncoding(HttpServletRequest httpRequest) {
        String bestEncoding;
        String forcedEncoding = (String)httpRequest.getAttribute("com.planet.servlet.filter.compression.ForceEncoding");
        if (forcedEncoding != null) {
            bestEncoding = forcedEncoding;
        } else {
            String acceptEncodingHeader = httpRequest.getHeader("Accept-Encoding");
            if (acceptEncodingHeader == null) {
                bestEncoding = NO_ENCODING;
            } else {
                bestEncoding = bestEncodingCache.get(acceptEncodingHeader);
                if (bestEncoding == null) {
                    bestEncoding = acceptEncodingHeader.indexOf(44) >= 0 ? CompressingStreamFactory.selectBestEncoding(acceptEncodingHeader) : CompressingStreamFactory.parseBestEncoding(acceptEncodingHeader);
                    bestEncodingCache.put(acceptEncodingHeader, bestEncoding);
                }
            }
        }
        if (!CompressingStreamFactory.isSupportedResponseContentEncoding(bestEncoding)) {
            bestEncoding = NO_ENCODING;
        }
        return bestEncoding;
    }

    private static String parseBestEncoding(String acceptEncodingHeader) {
        ContentEncodingQ contentEncodingQ = CompressingStreamFactory.parseContentEncodingQ(acceptEncodingHeader);
        String contentEncoding = contentEncodingQ.getContentEncoding();
        if (contentEncodingQ.getQ() > 0.0) {
            if (ANY_ENCODING.equals(contentEncoding)) {
                return supportedEncodings.get(0);
            }
            if (supportedEncodings.contains(contentEncoding)) {
                return contentEncoding;
            }
        }
        return NO_ENCODING;
    }

    private static String selectBestEncoding(String acceptEncodingHeader) {
        block8: {
            HashSet<String> bestEncodings;
            block7: {
                bestEncodings = new HashSet<String>(3);
                double bestQ = 0.0;
                HashSet<String> unacceptableEncodings = new HashSet<String>(3);
                boolean willAcceptAnything = false;
                for (String token : COMMA.split(acceptEncodingHeader)) {
                    ContentEncodingQ contentEncodingQ = CompressingStreamFactory.parseContentEncodingQ(token);
                    String contentEncoding = contentEncodingQ.getContentEncoding();
                    double q = contentEncodingQ.getQ();
                    if (ANY_ENCODING.equals(contentEncoding)) {
                        willAcceptAnything = q > 0.0;
                        continue;
                    }
                    if (!supportedEncodings.contains(contentEncoding)) continue;
                    if (q > 0.0) {
                        if (q == bestQ) {
                            bestEncodings.add(contentEncoding);
                            continue;
                        }
                        if (!(q > bestQ)) continue;
                        bestQ = q;
                        bestEncodings.clear();
                        bestEncodings.add(contentEncoding);
                        continue;
                    }
                    unacceptableEncodings.add(contentEncoding);
                }
                if (!bestEncodings.isEmpty()) break block7;
                if (!willAcceptAnything) break block8;
                if (unacceptableEncodings.isEmpty()) {
                    return supportedEncodings.get(0);
                }
                for (String encoding : supportedEncodings) {
                    if (unacceptableEncodings.contains(encoding)) continue;
                    return encoding;
                }
                break block8;
            }
            for (String encoding : supportedEncodings) {
                if (!bestEncodings.contains(encoding)) continue;
                return encoding;
            }
        }
        return NO_ENCODING;
    }

    private static ContentEncodingQ parseContentEncodingQ(String contentEncodingString) {
        String contentEncoding;
        double q = 1.0;
        int qvalueStartIndex = contentEncodingString.indexOf(59);
        if (qvalueStartIndex >= 0) {
            contentEncoding = contentEncodingString.substring(0, qvalueStartIndex).trim();
            String qvalueString = contentEncodingString.substring(qvalueStartIndex + 1).trim();
            if (qvalueString.startsWith("q=")) {
                try {
                    q = Double.parseDouble(qvalueString.substring(2));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            contentEncoding = contentEncodingString.trim();
        }
        return new ContentEncodingQ(contentEncoding, q);
    }

    static {
        Cloneable temp = new ArrayList<String>(6);
        temp.add(GZIP_ENCODING);
        temp.add(DEFLATE_ENCODING);
        temp.add(COMPRESS_ENCODING);
        temp.add(X_GZIP_ENCODING);
        temp.add(X_COMPRESS_ENCODING);
        temp.add(NO_ENCODING);
        supportedEncodings = Collections.unmodifiableList(temp);
        bestEncodingCache = Collections.synchronizedMap(new HashMap(101));
        COMMA = Pattern.compile(",");
        temp = new HashMap(11);
        temp.put(GZIP_ENCODING, GZIP_CSF);
        temp.put(X_GZIP_ENCODING, GZIP_CSF);
        temp.put(COMPRESS_ENCODING, ZIP_CSF);
        temp.put(X_COMPRESS_ENCODING, ZIP_CSF);
        temp.put(DEFLATE_ENCODING, DEFLATE_CSF);
        factoryMap = Collections.unmodifiableMap(temp);
    }

    private static class DeflateCompressingStreamFactory
    extends CompressingStreamFactory {
        private DeflateCompressingStreamFactory() {
        }

        @Override
        CompressingOutputStream getCompressingStream(final OutputStream outputStream, final CompressingFilterContext context) {
            return new CompressingOutputStream(){
                private final DeflaterOutputStream deflaterOutputStream;
                private final OutputStream statsOutputStream;
                {
                    this.deflaterOutputStream = new DeflaterOutputStream(CompressingStreamFactory.maybeWrapStatsOutputStream(outputStream, context, StatsField.RESPONSE_COMPRESSED_BYTES));
                    this.statsOutputStream = CompressingStreamFactory.maybeWrapStatsOutputStream(this.deflaterOutputStream, context, StatsField.RESPONSE_INPUT_BYTES);
                }

                @Override
                public OutputStream getCompressingOutputStream() {
                    return this.statsOutputStream;
                }

                @Override
                public void finish() throws IOException {
                    this.deflaterOutputStream.finish();
                }
            };
        }

        @Override
        CompressingInputStream getCompressingStream(final InputStream inputStream, final CompressingFilterContext context) {
            return new CompressingInputStream(){

                @Override
                public InputStream getCompressingInputStream() {
                    return CompressingStreamFactory.maybeWrapStatsInputStream(new InflaterInputStream(CompressingStreamFactory.maybeWrapStatsInputStream(inputStream, context, StatsField.REQUEST_COMPRESSED_BYTES)), context, StatsField.REQUEST_INPUT_BYTES);
                }
            };
        }
    }

    private static class ZipCompressingStreamFactory
    extends CompressingStreamFactory {
        private ZipCompressingStreamFactory() {
        }

        @Override
        CompressingOutputStream getCompressingStream(final OutputStream outputStream, final CompressingFilterContext context) {
            return new CompressingOutputStream(){
                private final DeflaterOutputStream zipOutputStream;
                private final OutputStream statsOutputStream;
                {
                    this.zipOutputStream = new ZipOutputStream(CompressingStreamFactory.maybeWrapStatsOutputStream(outputStream, context, StatsField.RESPONSE_COMPRESSED_BYTES));
                    this.statsOutputStream = CompressingStreamFactory.maybeWrapStatsOutputStream(this.zipOutputStream, context, StatsField.RESPONSE_INPUT_BYTES);
                }

                @Override
                public OutputStream getCompressingOutputStream() {
                    return this.statsOutputStream;
                }

                @Override
                public void finish() throws IOException {
                    this.zipOutputStream.finish();
                }
            };
        }

        @Override
        CompressingInputStream getCompressingStream(final InputStream inputStream, final CompressingFilterContext context) {
            return new CompressingInputStream(){

                @Override
                public InputStream getCompressingInputStream() {
                    return CompressingStreamFactory.maybeWrapStatsInputStream(new ZipInputStream(CompressingStreamFactory.maybeWrapStatsInputStream(inputStream, context, StatsField.REQUEST_COMPRESSED_BYTES)), context, StatsField.REQUEST_INPUT_BYTES);
                }
            };
        }
    }

    private static class GZIPCompressingStreamFactory
    extends CompressingStreamFactory {
        private GZIPCompressingStreamFactory() {
        }

        @Override
        CompressingOutputStream getCompressingStream(final OutputStream outputStream, final CompressingFilterContext context) throws IOException {
            return new CompressingOutputStream(){
                private final DeflaterOutputStream gzipOutputStream;
                private final OutputStream statsOutputStream;
                {
                    this.gzipOutputStream = new GZIPOutputStream(CompressingStreamFactory.maybeWrapStatsOutputStream(outputStream, context, StatsField.RESPONSE_COMPRESSED_BYTES));
                    this.statsOutputStream = CompressingStreamFactory.maybeWrapStatsOutputStream(this.gzipOutputStream, context, StatsField.RESPONSE_INPUT_BYTES);
                }

                @Override
                public OutputStream getCompressingOutputStream() {
                    return this.statsOutputStream;
                }

                @Override
                public void finish() throws IOException {
                    this.gzipOutputStream.finish();
                }
            };
        }

        @Override
        CompressingInputStream getCompressingStream(final InputStream inputStream, final CompressingFilterContext context) {
            return new CompressingInputStream(){

                @Override
                public InputStream getCompressingInputStream() throws IOException {
                    return CompressingStreamFactory.maybeWrapStatsInputStream(new GZIPInputStream(CompressingStreamFactory.maybeWrapStatsInputStream(inputStream, context, StatsField.REQUEST_COMPRESSED_BYTES)), context, StatsField.REQUEST_INPUT_BYTES);
                }
            };
        }
    }

    private static final class ContentEncodingQ {
        private final String contentEncoding;
        private final double q;

        private ContentEncodingQ(String contentEncoding, double q) {
            assert (contentEncoding != null && contentEncoding.length() > 0);
            this.contentEncoding = contentEncoding;
            this.q = q;
        }

        String getContentEncoding() {
            return this.contentEncoding;
        }

        double getQ() {
            return this.q;
        }

        public String toString() {
            return this.contentEncoding + ";q=" + this.q;
        }
    }
}

