/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.com.github.ziplet.filter.compression;

import java.io.Serializable;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.StatsField;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.statistics.CompressingFilterStats;

public class OutputStatsCallback
implements Serializable {
    private static final long serialVersionUID = -4483355731273629325L;
    private final StatsField field;
    private final CompressingFilterStats stats;

    public OutputStatsCallback(StatsField field, CompressingFilterStats stats) {
        this.field = field;
        this.stats = stats;
    }

    public void bytesWritten(int numBytes) {
        assert (numBytes >= 0);
        switch (this.field) {
            case RESPONSE_INPUT_BYTES: {
                this.stats.notifyResponseBytesWritten(numBytes);
                break;
            }
            case RESPONSE_COMPRESSED_BYTES: {
                this.stats.notifyCompressedResponseBytesWritten(numBytes);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public String toString() {
        return "OutputStatsCallback[field: " + this.field + ']';
    }
}

