/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.com.github.ziplet.filter.compression.statistics;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.statistics.CompressingFilterStats;

public class CompressingFilterStatsImpl
implements Serializable,
CompressingFilterStats {
    private static final long serialVersionUID = -2246829834191152845L;
    private static final String STATS_KEY = "org.qubership.profiler.shaded.com.github.ziplet.filter.compression.statistics.CompressingFilterStatsImpl";
    private AtomicInteger numResponsesCompressed = new AtomicInteger();
    private AtomicInteger totalResponsesNotCompressed = new AtomicInteger();
    private AtomicLong responseInputBytes = new AtomicLong();
    private AtomicLong responseCompressedBytes = new AtomicLong();
    private AtomicInteger numRequestsCompressed = new AtomicInteger();
    private AtomicInteger totalRequestsNotCompressed = new AtomicInteger();
    private AtomicLong requestInputBytes = new AtomicLong();
    private AtomicLong requestCompressedBytes = new AtomicLong();

    public int getNumResponsesCompressed() {
        return this.numResponsesCompressed.get();
    }

    @Override
    public void incrementNumResponsesCompressed() {
        this.numResponsesCompressed.incrementAndGet();
    }

    public int getTotalResponsesNotCompressed() {
        return this.totalResponsesNotCompressed.get();
    }

    @Override
    public void incrementTotalResponsesNotCompressed() {
        this.totalResponsesNotCompressed.incrementAndGet();
    }

    @Deprecated
    public long getInputBytes() {
        return this.getResponseInputBytes();
    }

    public long getResponseInputBytes() {
        return this.responseInputBytes.get();
    }

    @Deprecated
    public long getCompressedBytes() {
        return this.getResponseCompressedBytes();
    }

    public long getResponseCompressedBytes() {
        return this.responseCompressedBytes.get();
    }

    @Deprecated
    public double getAverageCompressionRatio() {
        return this.getResponseAverageCompressionRatio();
    }

    public double getResponseAverageCompressionRatio() {
        return this.getResponseCompressedBytes() == 0L ? 0.0 : (double)this.getResponseInputBytes() / (double)this.getResponseCompressedBytes();
    }

    public int getNumRequestsCompressed() {
        return this.numRequestsCompressed.get();
    }

    @Override
    public void incrementNumRequestsCompressed() {
        this.numRequestsCompressed.incrementAndGet();
    }

    public int getTotalRequestsNotCompressed() {
        return this.totalRequestsNotCompressed.get();
    }

    @Override
    public void incrementTotalRequestsNotCompressed() {
        this.totalRequestsNotCompressed.incrementAndGet();
    }

    public long getRequestInputBytes() {
        return this.requestInputBytes.get();
    }

    public long getRequestCompressedBytes() {
        return this.requestCompressedBytes.get();
    }

    public double getRequestAverageCompressionRatio() {
        return this.requestCompressedBytes.get() == 0L ? 0.0 : (double)this.requestInputBytes.get() / (double)this.requestCompressedBytes.get();
    }

    public String toString() {
        return "CompressingFilterStatsImpl[responses compressed: " + this.numResponsesCompressed + ", avg. response compression ratio: " + this.getResponseAverageCompressionRatio() + ", requests compressed: " + this.numRequestsCompressed + ", avg. request compression ratio: " + this.getRequestAverageCompressionRatio() + ']';
    }

    @Override
    public void notifyRequestBytesRead(long read) {
        this.requestInputBytes.addAndGet(read);
    }

    @Override
    public void notifyCompressedRequestBytesRead(long read) {
        this.requestCompressedBytes.addAndGet(read);
    }

    @Override
    public void notifyResponseBytesWritten(long written) {
        this.responseInputBytes.addAndGet(written);
    }

    @Override
    public void notifyCompressedResponseBytesWritten(long written) {
        this.responseCompressedBytes.addAndGet(written);
    }

    @Override
    public String getStatsKey() {
        return STATS_KEY;
    }
}

