/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.gnu.trove.decorator;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.qubership.profiler.shaded.gnu.trove.TDoubleByteHashMap;
import org.qubership.profiler.shaded.gnu.trove.TDoubleByteIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TDoubleByteHashMapDecorator
extends AbstractMap<Double, Byte>
implements Map<Double, Byte>,
Externalizable,
Cloneable {
    protected TDoubleByteHashMap _map;

    public TDoubleByteHashMapDecorator() {
    }

    public TDoubleByteHashMapDecorator(TDoubleByteHashMap map) {
        this._map = map;
    }

    public TDoubleByteHashMap getMap() {
        return this._map;
    }

    @Override
    public TDoubleByteHashMapDecorator clone() {
        try {
            TDoubleByteHashMapDecorator copy = (TDoubleByteHashMapDecorator)super.clone();
            copy._map = (TDoubleByteHashMap)this._map.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Byte put(Double key, Byte value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    public Byte get(Double key) {
        double k = this.unwrapKey(key);
        byte v = this._map.get(k);
        if (v == 0) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Byte remove(Double key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Set<Map.Entry<Double, Byte>> entrySet() {
        return new AbstractSet<Map.Entry<Double, Byte>>(){

            @Override
            public int size() {
                return TDoubleByteHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TDoubleByteHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TDoubleByteHashMapDecorator.this.containsKey(k) && ((Byte)TDoubleByteHashMapDecorator.this.get(k)).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Double, Byte>> iterator() {
                return new Iterator<Map.Entry<Double, Byte>>(){
                    private final TDoubleByteIterator it;
                    {
                        this.it = TDoubleByteHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Double, Byte> next() {
                        this.it.advance();
                        final Double key = TDoubleByteHashMapDecorator.this.wrapKey(this.it.key());
                        final Byte v = TDoubleByteHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Double, Byte>(){
                            private Byte val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public Double getKey() {
                                return key;
                            }

                            @Override
                            public Byte getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Byte setValue(Byte value) {
                                this.val = value;
                                return TDoubleByteHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Byte o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Double, Byte>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TDoubleByteHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Byte> map) {
        Iterator<Map.Entry<? extends Double, ? extends Byte>> it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry<? extends Double, ? extends Byte> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Double wrapKey(double k) {
        return k;
    }

    protected double unwrapKey(Object key) {
        return (Double)key;
    }

    protected Byte wrapValue(byte k) {
        return k;
    }

    protected byte unwrapValue(Object value) {
        return (Byte)value;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this._map = (TDoubleByteHashMap)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeObject(this._map);
    }
}

