/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.collection;

import java.util.Iterator;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.collection.IteratorToolkit;

public abstract class KeyInValueMap<K, V>
implements Iterable<V> {
    private Object[] values;
    private int size;
    private int capacity;
    private int threshold;
    private final float loadFactor;

    public KeyInValueMap(int initialCapacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.createTable(initialCapacity);
    }

    public V get(K key, boolean computeIfAbsent) {
        int idx = this.getIndex(this.hashKey(key));
        while (this.values[idx] != null) {
            V e = this.getValue(idx);
            if (this.isKeyFor(key, e)) {
                return e;
            }
            idx = (idx + 1) % this.capacity;
        }
        if (computeIfAbsent) {
            V entry = this.computeValue(key);
            this.values[idx] = entry;
            ++this.size;
            if (this.size > this.threshold) {
                this.rehash();
            }
            return entry;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<V> iterator() {
        return IteratorToolkit.skipNulls(IteratorToolkit.of(this.values));
    }

    private void createTable(int newCapacity) {
        this.capacity = newCapacity | 1;
        this.threshold = (int)((float)this.capacity * this.loadFactor);
        this.values = new Object[this.capacity];
    }

    private V getValue(int index) {
        return (V)this.values[index];
    }

    private void rehash() {
        Object[] oldEntries = this.values;
        this.createTable(this.capacity * 2);
        for (Object oldEntry : oldEntries) {
            if (oldEntry == null) continue;
            Object e = oldEntry;
            int idx = this.getIndex(this.hashFromValue(e));
            while (this.values[idx] != null) {
                idx = (idx + 1) % this.capacity;
            }
            this.values[idx] = oldEntry;
        }
    }

    private int getIndex(int hash) {
        return (hash & Integer.MAX_VALUE) % this.capacity;
    }

    private boolean isKeyFor(K key, V value) {
        return this.getKey(value).equals(key);
    }

    protected abstract V computeValue(K var1);

    protected int hashKey(K key) {
        return key.hashCode();
    }

    private int hashFromValue(V value) {
        return this.hashKey(this.getKey(value));
    }

    protected abstract K getKey(V var1);
}

