/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.collection;

import java.util.Arrays;
import java.util.Iterator;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.collection.IteratorToolkit;

public class SimpleArray<T>
implements Iterable<T> {
    private T[] elements;
    private int size;

    public SimpleArray(T[] initial) {
        this(initial, 0);
    }

    public SimpleArray(T[] initial, int size) {
        this.elements = initial;
        this.size = size;
        if (initial.length < size || size < 0) {
            throw new IllegalArgumentException("Invalid number of preallocated elements (" + size + "). Must be between 0 and the initial array length (" + initial.length + ").");
        }
    }

    public T get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.elements[index];
    }

    public void add(T element) {
        if (this.size + 1 > this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, Math.max(this.calculateNewCapacity(this.elements.length), 3));
        }
        this.elements[this.size++] = element;
    }

    public void addAll(T[] src) {
        this.addAll(src, 0, src.length);
    }

    private void addAll(T[] src, int offset, int len) {
        if (this.size + len > this.elements.length) {
            int newCapacity = Math.max(this.calculateNewCapacity(this.elements.length), (this.size + len) * 2);
            this.elements = Arrays.copyOf(this.elements, newCapacity);
        }
        System.arraycopy(src, offset, this.elements, this.size, len);
        this.size += len;
    }

    public void copyTo(T[] dst, int offset) {
        System.arraycopy(this.elements, 0, dst, offset, this.size);
    }

    protected int calculateNewCapacity(int currentCapacity) {
        return currentCapacity * 10;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public T[] elements() {
        if (this.size < this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, this.size);
        }
        return this.elements;
    }

    @Override
    public Iterator<T> iterator() {
        return IteratorToolkit.of(this.elements, 0, this.size);
    }
}

