/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.collection.EntryHashMap;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.Aggregators;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IAccessorFactory;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IAggregator;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IItem;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IItemConsumer;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IItemConsumerFactory;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IMemberAccessor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IType;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.ItemToolkit;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.IQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.UnitLookup;

public class GroupingAggregator {
    public static <V, K, C extends IItemConsumer<C>> IAggregator<V, ?> build(String name, String description, IAccessorFactory<K> keyField, IItemConsumerFactory<C> groupAggregator, Predicate<IType<IItem>> acceptType, IGroupsFinisher<V, K, C> finisher) {
        return new GroupingAggregatorImpl<V, K, C>(name, description, keyField, groupAggregator, acceptType, finisher);
    }

    public static <V, K, C extends IItemConsumer<C>> IAggregator<V, ?> build(String name, String description, IAccessorFactory<K> keyField, final IAggregator<?, C> a, IGroupsFinisher<V, K, C> finisher) {
        return GroupingAggregator.build(name, description, keyField, a, new Predicate<IType<IItem>>(){

            @Override
            public boolean test(IType<IItem> o) {
                return a.acceptType(o);
            }
        }, finisher);
    }

    public static <K, C extends IItemConsumer<C>> IAggregator<Iterable<? extends GroupEntry<K, C>>, ?> build(String name, String description, IAccessorFactory<K> keyField, IItemConsumerFactory<C> groupAggregator, Predicate<IType<IItem>> acceptType) {
        return GroupingAggregator.build(name, description, keyField, groupAggregator, acceptType, new IGroupsFinisher<Iterable<? extends GroupEntry<K, C>>, K, C>(){

            @Override
            public IType<Object> getValueType() {
                return UnitLookup.UNKNOWN;
            }

            @Override
            public Iterable<? extends GroupEntry<K, C>> getValue(Iterable<? extends GroupEntry<K, C>> groups) {
                return groups;
            }
        });
    }

    public static <V, K, C extends IItemConsumer<C>> IAggregator<V, ?> build(String name, String description, IAccessorFactory<K> keyField, final IAggregator<IQuantity, C> a, final IQuantityListFinisher<V> groupFinisher) {
        return GroupingAggregator.build(name, description, keyField, a, new IGroupsFinisher<V, K, C>(){

            @Override
            public IType<? super V> getValueType() {
                return groupFinisher.getValueType();
            }

            @Override
            public V getValue(Iterable<? extends GroupEntry<K, C>> groups) {
                Iterator groupsIterator = groups.iterator();
                if (groupsIterator.hasNext()) {
                    ArrayList<IQuantity> values = new ArrayList<IQuantity>();
                    while (groupsIterator.hasNext()) {
                        values.add((IQuantity)a.getValue(Arrays.asList((IItemConsumer)groupsIterator.next().getConsumer()).iterator()));
                    }
                    Collections.sort(values);
                    IQuantity total = (IQuantity)a.getValue(GroupingAggregator.consumerIterator(groups.iterator()));
                    return groupFinisher.getValue(values, total);
                }
                return null;
            }
        });
    }

    public static <V, C extends IItemConsumer<C>> IAggregator<IQuantity, ?> buildMax(String name, String description, IAccessorFactory<?> keyField, final IAggregator<IQuantity, C> aggregate) {
        IQuantityListFinisher<IQuantity> gf = new IQuantityListFinisher<IQuantity>(){

            @Override
            public IType<? super IQuantity> getValueType() {
                return aggregate.getValueType();
            }

            @Override
            public IQuantity getValue(List<IQuantity> values, IQuantity total) {
                return values.size() == 0 ? null : values.get(values.size() - 1);
            }
        };
        return GroupingAggregator.build(name, description, keyField, aggregate, gf);
    }

    private static <G> Iterator<G> consumerIterator(final Iterator<? extends GroupEntry<?, G>> it) {
        return new Iterator<G>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public G next() {
                return ((GroupEntry)it.next()).getConsumer();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class GroupingAggregatorImpl<V, K, G extends IItemConsumer<G>>
    extends Aggregators.MergingAggregator<V, GroupingConsumer<K, G>> {
        private final IGroupsFinisher<V, K, G> groupsFinisher;
        private final IAccessorFactory<K> keyField;
        private final IItemConsumerFactory<G> consumerFactory;
        private final Predicate<IType<IItem>> acceptType;

        GroupingAggregatorImpl(String name, String description, IAccessorFactory<K> keyField, IItemConsumerFactory<G> consumerFactory, Predicate<IType<IItem>> acceptType, IGroupsFinisher<V, K, G> groupsFinisher) {
            super(name, description, groupsFinisher.getValueType());
            this.consumerFactory = consumerFactory;
            this.acceptType = acceptType;
            this.keyField = keyField;
            this.groupsFinisher = groupsFinisher;
        }

        @Override
        public boolean acceptType(IType<IItem> type) {
            return this.keyField.getAccessor(type) != null && this.acceptType.test(type);
        }

        @Override
        public GroupingConsumer<K, G> newItemConsumer(IType<IItem> type) {
            return new GroupingConsumer(this.keyField.getAccessor(type), this.consumerFactory);
        }

        @Override
        public V getValue(final GroupingConsumer<K, G> consumer) {
            return this.groupsFinisher.getValue(new Iterable<ObjectEntry<K, G>>(){

                @Override
                public Iterator<ObjectEntry<K, G>> iterator() {
                    return consumer.getGroups();
                }
            });
        }
    }

    private static class GroupingConsumer<K, G extends IItemConsumer<G>>
    implements IItemConsumer<GroupingConsumer<K, G>> {
        private EntryHashMap<K, ObjectEntry<K, G>> map;
        private final IMemberAccessor<? extends K, IItem> keyAccessor;
        private final IItemConsumerFactory<G> groupAggregator;

        private GroupingConsumer(IMemberAccessor<? extends K, IItem> keyAccessor, IItemConsumerFactory<G> groupAggregator) {
            this.keyAccessor = keyAccessor;
            this.groupAggregator = groupAggregator;
        }

        @Override
        public void consume(IItem item) {
            this.initialize(ItemToolkit.getItemType(item));
            K key = this.keyAccessor.getMember(item);
            if (key != null) {
                ((IItemConsumer)((ObjectEntry)this.map.get(key, true)).value).consume(item);
            }
        }

        private void initialize(final IType<IItem> type) {
            if (this.map == null) {
                this.map = new EntryHashMap<K, ObjectEntry<K, G>>(1000, 0.5f){

                    @Override
                    protected ObjectEntry<K, G> computeValue(K key) {
                        return new ObjectEntry(key, groupAggregator.newItemConsumer(type));
                    }
                };
            }
        }

        @Override
        public GroupingConsumer<K, G> merge(GroupingConsumer<K, G> other) {
            if (this.map != null && other != null && other.map != null) {
                for (ObjectEntry otherEntry : other.map) {
                    ObjectEntry thisEntry = (ObjectEntry)this.map.get(otherEntry.getKey(), true);
                    thisEntry.value = ((IItemConsumer)thisEntry.value).merge(otherEntry.value);
                }
            } else if (other != null && other.map != null) {
                this.map = other.map;
            }
            return this;
        }

        Iterator<ObjectEntry<K, G>> getGroups() {
            return this.map == null ? Collections.emptyList().iterator() : this.map.iterator();
        }
    }

    private static class ObjectEntry<K, V>
    extends EntryHashMap.Entry<K>
    implements GroupEntry<K, V> {
        private V value;

        public ObjectEntry(K key, V value) {
            super(key);
            this.value = value;
        }

        @Override
        public V getConsumer() {
            return this.value;
        }
    }

    public static interface IQuantityListFinisher<V> {
        public IType<? super V> getValueType();

        public V getValue(List<IQuantity> var1, IQuantity var2);
    }

    public static interface IGroupsFinisher<V, K, G> {
        public IType<? super V> getValueType();

        public V getValue(Iterable<? extends GroupEntry<K, G>> var1);
    }

    public static interface GroupEntry<K, G> {
        public K getKey();

        public G getConsumer();
    }
}

