/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.unit;

import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.BinaryPrefix;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.DecimalScaleFactor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ImpreciseScaleFactor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.LongScaleFactor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ScaleFactor;

public class BinaryScaleFactor
extends ScaleFactor {
    protected final int powerOf2;

    public static BinaryScaleFactor get(int powerOf2) {
        if (powerOf2 >= 0) {
            if (powerOf2 < Cache.POS_POWERS.length) {
                return Cache.POS_POWERS[powerOf2];
            }
        } else if (powerOf2 > -Cache.NEG_POWERS.length) {
            return Cache.NEG_POWERS[-powerOf2];
        }
        return new BinaryScaleFactor(powerOf2);
    }

    public static BinaryScaleFactor getFloor2Factor(long value) {
        return BinaryScaleFactor.get(BinaryPrefix.getFloorLog2(value));
    }

    public static BinaryScaleFactor getFloor1024Factor(double value) {
        return BinaryScaleFactor.get(BinaryPrefix.getFloorLog1024(value) * 10);
    }

    private BinaryScaleFactor(int powerOf2) {
        this.powerOf2 = powerOf2;
    }

    @Override
    public double getMultiplier() {
        return Math.scalb(1.0, this.powerOf2);
    }

    public StringBuilder asExponentialStringBuilder(boolean multiplicationSign) {
        StringBuilder out = new StringBuilder(multiplicationSign ? "\u00d72" : "2");
        DecimalScaleFactor.appendExponentTo(this.powerOf2, out);
        return out;
    }

    @Override
    public boolean targetOutOfRange(long srcNumericalValue, long maxAbsValue) {
        return this.powerOf2 >= 0 && srcNumericalValue != 0L;
    }

    @Override
    public boolean targetOutOfRange(double srcNumericalValue, long maxAbsValue) {
        if (srcNumericalValue >= 0.0) {
            return srcNumericalValue >= -Math.scalb((double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL), -this.powerOf2);
        }
        return srcNumericalValue < Math.scalb((double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL), -this.powerOf2);
    }

    @Override
    public long targetValue(long srcNumericalValue) {
        if (this.powerOf2 >= 0 && srcNumericalValue != 0L) {
            return srcNumericalValue >= 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return 0L;
    }

    @Override
    public long targetFloor(long srcNumericalValue) {
        if (this.powerOf2 >= 0) {
            if (srcNumericalValue == 0L) {
                return 0L;
            }
            return srcNumericalValue >= 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return srcNumericalValue >= 0L ? 0L : -1L;
    }

    @Override
    public double targetValue(double srcNumericalValue) {
        return Math.scalb(srcNumericalValue, this.powerOf2);
    }

    @Override
    public boolean isUnity() {
        return this.powerOf2 == 0;
    }

    @Override
    public boolean isInteger() {
        return this.powerOf2 >= 0;
    }

    @Override
    public ScaleFactor concat(ScaleFactor innerFactor) {
        if (innerFactor.isUnity()) {
            return this;
        }
        if (innerFactor instanceof BinaryScaleFactor) {
            return BinaryScaleFactor.get(this.powerOf2 + ((BinaryScaleFactor)innerFactor).powerOf2);
        }
        return new ImpreciseScaleFactor(innerFactor.targetValue(this.getMultiplier()));
    }

    @Override
    public BinaryScaleFactor invert() {
        return BinaryScaleFactor.get(-this.powerOf2);
    }

    @Override
    public int compareTo(ScaleFactor other) {
        if (other instanceof BinaryScaleFactor) {
            return this.powerOf2 - ((BinaryScaleFactor)other).powerOf2;
        }
        return super.compareTo(other);
    }

    @Override
    public boolean equals(Object other) {
        if (this.powerOf2 == 0) {
            return other instanceof ScaleFactor && ((ScaleFactor)other).isUnity();
        }
        return other instanceof BinaryScaleFactor && ((BinaryScaleFactor)other).powerOf2 == this.powerOf2;
    }

    @Override
    public int hashCode() {
        return this.powerOf2;
    }

    private static class Cache {
        private static final BinaryScaleFactor[] POS_POWERS;
        private static final BinaryScaleFactor[] NEG_POWERS;

        private Cache() {
        }

        static {
            BinaryScaleFactor[] posPowers = new BinaryScaleFactor[64];
            BinaryScaleFactor[] negPowers = new BinaryScaleFactor[64];
            posPowers[0] = negPowers[0] = new Unity();
            for (int i = 1; i < 64; ++i) {
                posPowers[i] = new UpSmall(i);
                negPowers[i] = new DownSmall(-i);
            }
            POS_POWERS = posPowers;
            NEG_POWERS = negPowers;
        }
    }

    private static class DownSmall
    extends BinaryScaleFactor {
        public DownSmall(int powerOf2) {
            super(powerOf2);
            assert (powerOf2 < 0);
            assert (powerOf2 > -64);
        }

        @Override
        public boolean targetOutOfRange(long srcNumericalValue, long maxAbsValue) {
            if (srcNumericalValue >= 0L) {
                return this.targetValue(srcNumericalValue) > maxAbsValue;
            }
            return this.targetValue(srcNumericalValue) < (maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL);
        }

        @Override
        public long targetValue(long srcNumericalValue) {
            return (srcNumericalValue >> -this.powerOf2 - 1) + 1L >> 1;
        }

        @Override
        public long targetFloor(long srcNumericalValue) {
            return srcNumericalValue >> -this.powerOf2;
        }

        @Override
        public BinaryScaleFactor invert() {
            return Cache.POS_POWERS[-this.powerOf2];
        }
    }

    private static class UpSmall
    extends BinaryScaleFactor {
        public UpSmall(int powerOf2) {
            super(powerOf2);
            assert (powerOf2 > 0);
            assert (powerOf2 < 64);
        }

        @Override
        public ScaleFactor concat(ScaleFactor innerFactor) {
            if (innerFactor.isUnity()) {
                return this;
            }
            if (innerFactor instanceof BinaryScaleFactor) {
                return UpSmall.get(this.powerOf2 + ((BinaryScaleFactor)innerFactor).powerOf2);
            }
            long longMultiplier = 1L << this.powerOf2;
            Number multiplier = innerFactor.targetNumber(longMultiplier);
            if (multiplier instanceof Long) {
                return new LongScaleFactor(multiplier.longValue());
            }
            return new ImpreciseScaleFactor(multiplier);
        }

        @Override
        public boolean targetOutOfRange(long srcNumericalValue, long maxAbsValue) {
            if (srcNumericalValue >= 0L) {
                return srcNumericalValue > maxAbsValue >> this.powerOf2;
            }
            return srcNumericalValue < (maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) >> this.powerOf2;
        }

        @Override
        public long targetValue(long srcNumericalValue) {
            return this.targetFloor(srcNumericalValue);
        }

        @Override
        public long targetFloor(long srcNumericalValue) {
            if (this.targetOutOfRange(srcNumericalValue, Long.MAX_VALUE)) {
                return srcNumericalValue >= 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
            }
            return srcNumericalValue << this.powerOf2;
        }

        @Override
        public BinaryScaleFactor invert() {
            return Cache.NEG_POWERS[this.powerOf2];
        }
    }

    private static class Unity
    extends BinaryScaleFactor {
        public Unity() {
            super(0);
        }

        @Override
        public boolean targetOutOfRange(long srcNumericalValue, long maxAbsValue) {
            if (srcNumericalValue >= 0L) {
                return srcNumericalValue > maxAbsValue;
            }
            return srcNumericalValue < (maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL);
        }

        @Override
        public long targetValue(long srcNumericalValue) {
            return srcNumericalValue;
        }

        @Override
        public long targetFloor(long srcNumericalValue) {
            return srcNumericalValue;
        }

        @Override
        public double targetValue(double srcNumericalValue) {
            return srcNumericalValue;
        }

        @Override
        public BinaryScaleFactor invert() {
            return this;
        }
    }
}

