/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.unit;

import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.DecimalPrefix;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.DecimalScaleFactor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ITypedQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.LinearUnit;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ScaleFactor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.TypedUnit;

public class DecimalUnitSelector
implements LinearKindOfQuantity.LinearUnitSelector {
    protected final LinearKindOfQuantity kindOfQuantity;
    protected final LinearUnit exponentialBaseUnit;
    protected final ScaleFactor baseToAtomFactor;
    protected final Map<ScaleFactor, LinearUnit> unitCache = new HashMap<ScaleFactor, LinearUnit>();

    public DecimalUnitSelector(LinearKindOfQuantity kindOfQuantity) {
        this(kindOfQuantity, kindOfQuantity.atomUnit);
    }

    public DecimalUnitSelector(LinearKindOfQuantity kindOfQuantity, LinearUnit exponentialBaseUnit) {
        this.kindOfQuantity = kindOfQuantity;
        this.exponentialBaseUnit = exponentialBaseUnit;
        this.baseToAtomFactor = exponentialBaseUnit.valueTransformTo(kindOfQuantity.atomUnit);
        this.cachePlain(-3, "\u00d70.001");
        this.cachePlain(-2, "\u00d70.01");
        this.cachePlain(-1, "\u00d70.1");
        this.unitCache.put(DecimalScaleFactor.get(0), exponentialBaseUnit);
        this.cachePlain(1, "\u00d710");
        this.cachePlain(2, "\u00d7100");
        this.cachePlain(3, "\u00d71000");
    }

    public DecimalUnitSelector(LinearKindOfQuantity kindOfQuantity, Iterable<DecimalPrefix> prefixes) {
        this(kindOfQuantity, kindOfQuantity.atomUnit);
        for (DecimalPrefix prefix : prefixes) {
            this.unitCache.put(prefix.scaleFactor(), kindOfQuantity.getUnit(prefix));
        }
    }

    protected void cachePlain(int powerOf10, String unitId) {
        DecimalScaleFactor factor = DecimalScaleFactor.get(powerOf10);
        String unitName = unitId.replace('.', DecimalFormatSymbols.getInstance().getDecimalSeparator()) + this.exponentialBaseUnit.getAppendableSuffix(false);
        ScaleFactor atomFactor = this.baseToAtomFactor.concat(factor);
        LinearUnit unit = new LinearUnit(this.kindOfQuantity, null, atomFactor, unitName, unitName, new String[0]);
        this.unitCache.put(factor, unit);
    }

    @Override
    public LinearUnit getPreferredUnit(ITypedQuantity<LinearUnit> quantity, double minNumericalValue, double maxNumericalValue) {
        double absVal = Math.abs(quantity.doubleValueIn(this.exponentialBaseUnit));
        if (absVal > minNumericalValue && absVal < maxNumericalValue) {
            return this.exponentialBaseUnit;
        }
        if (minNumericalValue > 1.0) {
            return this.getRegularUnit(absVal / minNumericalValue, maxNumericalValue / minNumericalValue);
        }
        return this.getRegularUnit(absVal, maxNumericalValue);
    }

    private LinearUnit getRegularUnit(double absValInBaseUnit, double maxNumericalValue) {
        if (maxNumericalValue >= 1000.0) {
            return this.getUnit(DecimalScaleFactor.getEngFloorFactor(absValInBaseUnit));
        }
        return this.getUnit(DecimalScaleFactor.getSciFloorFactor(absValInBaseUnit));
    }

    private LinearUnit getUnit(DecimalScaleFactor factor) {
        LinearUnit unit = this.unitCache.get(factor);
        if (unit == null) {
            String unitName = factor.asExponentialStringBuilder(true).append(this.exponentialBaseUnit.getAppendableSuffix(false)).toString();
            ScaleFactor atomFactor = this.baseToAtomFactor.concat(factor);
            unit = new LinearUnit(this.kindOfQuantity, null, atomFactor, unitName, unitName, new String[0]);
            this.unitCache.put(factor, unit);
        }
        return unit;
    }

    @Override
    public ITypedQuantity<LinearUnit> snapToBestBetweenHalfAndEqual(ITypedQuantity<LinearUnit> upperLimit) {
        long base;
        assert (Math.abs(upperLimit.doubleValue()) > 0.0);
        TypedUnit quantaUnit = this.getPreferredUnit((ITypedQuantity)upperLimit, 10.0, 10000.0);
        double max = upperLimit.doubleValueIn(quantaUnit);
        double quotient = max / (double)(base = (long)(Math.pow(10.0, DecimalPrefix.getFloorLog10(max)) * Math.signum(max)));
        if (quotient > 5.0) {
            return ((LinearUnit)quantaUnit).quantity(base * 5L);
        }
        if (quotient > 4.0) {
            if ((base & 1L) == 0L) {
                return ((LinearUnit)quantaUnit).quantity(base * 5L >> 1);
            }
            return ((LinearUnit)quantaUnit).quantity((double)base * 2.5);
        }
        if (quotient > 2.0) {
            return ((LinearUnit)quantaUnit).quantity(base * 2L);
        }
        return ((LinearUnit)quantaUnit).quantity(base);
    }

    @Override
    public LinearUnit getLargestExactUnit(ITypedQuantity<LinearUnit> quantity) {
        if (quantity.doubleValue() == 0.0) {
            return (LinearUnit)quantity.getUnit();
        }
        double absVal = Math.abs(quantity.doubleValueIn(this.exponentialBaseUnit));
        int minLog10 = DecimalPrefix.YOCTO.powerOf10();
        for (int log10 = DecimalPrefix.getFloorLog1000(absVal) * 3; log10 >= minLog10; log10 -= 3) {
            LinearUnit unit;
            DecimalScaleFactor inverseFactor = DecimalScaleFactor.get(-log10);
            double scaled = inverseFactor.targetValue(absVal);
            if (scaled != Math.rint(scaled) || (unit = this.unitCache.get(DecimalScaleFactor.get(log10))) == null || unit.getIdentifier() == null) continue;
            return unit;
        }
        return null;
    }
}

