/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.unit;

import java.text.NumberFormat;
import java.util.Collections;
import java.util.Map;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ITypedQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.QuantityConversionException;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ScalarQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ScaleFactor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.TypedUnit;

public class LinearUnit
extends TypedUnit<LinearUnit>
implements Comparable<LinearUnit> {
    private final LinearKindOfQuantity kindOfQuantity;
    private final ScaleFactor factorToAtom;
    private final String unitId;
    private final String idSuffix;
    private final String unitSymbol;
    private final String nonBreakingSuffix;
    private final String breakingSuffix;
    private final String unitDescription;
    private final String[] altNames;
    private final Map<String, ? extends LinearUnit> parseMap;

    public LinearUnit(LinearKindOfQuantity kindOfQuantity, String unitId, ScaleFactor factorToAtom, String unitSymbol, String unitDesc, String ... altNames) {
        this.kindOfQuantity = kindOfQuantity;
        this.unitId = unitId;
        this.idSuffix = unitId == null || unitId.length() == 0 ? "" : " " + unitId;
        this.unitSymbol = unitSymbol;
        this.nonBreakingSuffix = unitSymbol.length() == 0 ? "" : "\u00a0" + unitSymbol;
        this.breakingSuffix = this.nonBreakingSuffix.replace('\u00a0', ' ');
        this.unitDescription = unitDesc;
        this.factorToAtom = factorToAtom;
        this.altNames = altNames != null ? altNames : EMPTY_STRING_ARRAY;
        this.parseMap = Collections.singletonMap(unitSymbol.replace('\u00a0', ' '), this);
    }

    @Override
    protected final Class<LinearUnit> getUnitClass() {
        return LinearUnit.class;
    }

    public LinearKindOfQuantity getContentType() {
        return this.kindOfQuantity;
    }

    @Override
    public LinearUnit getDeltaUnit() {
        return this;
    }

    @Override
    protected LinearUnit getScaledUnit(LinearUnit deltaUnit) {
        return deltaUnit;
    }

    @Override
    public String getAppendableSuffix(boolean useBreakingSpace) {
        return useBreakingSpace ? this.breakingSuffix : this.nonBreakingSuffix;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LinearUnit) {
            LinearUnit otherUnit = (LinearUnit)other;
            return this.kindOfQuantity.equals(otherUnit.kindOfQuantity) && this.factorToAtom.equals(otherUnit.factorToAtom);
        }
        return false;
    }

    public int hashCode() {
        return (this.kindOfQuantity.hashCode() << 16) + this.factorToAtom.hashCode();
    }

    @Override
    public int compareTo(LinearUnit other) {
        return this.factorToAtom.compareTo(other.factorToAtom);
    }

    @Override
    public ITypedQuantity<LinearUnit> quantity(long numericalValue) {
        return new ScalarQuantity.LongStored<LinearUnit>(numericalValue, this);
    }

    @Override
    public ITypedQuantity<LinearUnit> quantity(double numericalValue) {
        return new ScalarQuantity.DoubleStored<LinearUnit>(numericalValue, this);
    }

    public ScaleFactor valueTransformTo(LinearUnit targetUnit) {
        if (targetUnit.getContentType() != this.getContentType()) {
            throw new IllegalArgumentException("Cannot convert from unit " + this + " into unit of type " + targetUnit.getContentType().getIdentifier());
        }
        return targetUnit.valueFactorToAtom().invertAndConcat(this.factorToAtom);
    }

    private ScaleFactor valueFactorToAtom() {
        return this.factorToAtom;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    protected ITypedQuantity<LinearUnit> add(long numericalAugend, LinearUnit addendUnit, long numericalAddend) {
        int comparision = this.compareTo(addendUnit);
        if (comparision == 0) {
            long sum = numericalAugend + numericalAddend;
            if (((numericalAugend ^ sum) & (numericalAddend ^ sum)) >= 0L) {
                return this.quantity(numericalAugend + numericalAddend);
            }
            return this.quantity((double)numericalAugend + (double)numericalAddend);
        }
        if (comparision < 0) {
            return this.addPossiblyIntegral(numericalAugend, addendUnit.valueTransformTo(this), numericalAddend);
        }
        return addendUnit.addPossiblyIntegral(numericalAddend, this.valueTransformTo(addendUnit), numericalAugend);
    }

    @Override
    protected ITypedQuantity<LinearUnit> subtractSame(long numericalMinuend, LinearUnit subtrahendUnit, long numericalSubtrahend) {
        return this.add(numericalMinuend, subtrahendUnit, -numericalSubtrahend);
    }

    private long floorQuantize(long value, long alignment) {
        if (value >= 0L) {
            return value / alignment * alignment;
        }
        return ((value ^ 0xFFFFFFFFFFFFFFFFL) / alignment ^ 0xFFFFFFFFFFFFFFFFL) * alignment;
    }

    @Override
    protected ITypedQuantity<LinearUnit> floorQuantize(long numericalValue, ITypedQuantity<LinearUnit> quanta) {
        long maybeLongQuanta;
        double quantaInThisUnit;
        LinearUnit quantaUnit = (LinearUnit)quanta.getUnit();
        if (quanta instanceof ScalarQuantity.LongStored) {
            long quantaSize = quanta.longValue();
            ScaleFactor scaleToQuanta = this.valueTransformTo(quantaUnit);
            if (!scaleToQuanta.targetOutOfRange(numericalValue, Long.MAX_VALUE - quantaSize)) {
                long alignedNumerical = this.floorQuantize(scaleToQuanta.targetFloor(numericalValue), quantaSize);
                return quantaUnit.quantity(alignedNumerical);
            }
        }
        if ((quantaInThisUnit = quanta.doubleValueIn(this)) == (double)(maybeLongQuanta = (long)quantaInThisUnit)) {
            return this.quantity(this.floorQuantize(numericalValue, maybeLongQuanta));
        }
        double alignedNumerical = Math.floor((double)numericalValue / quantaInThisUnit) * quantaInThisUnit;
        return this.quantity(alignedNumerical);
    }

    @Override
    protected ITypedQuantity<LinearUnit> floorQuantize(double numericalValue, ITypedQuantity<LinearUnit> quanta) {
        double quantaInStartUnit = quanta.doubleValueIn(this);
        double alignedStartNumerical = Math.floor(numericalValue / quantaInStartUnit) * quantaInStartUnit;
        return this.quantity(alignedStartNumerical);
    }

    public String toString() {
        return this.getIdentifier() + '[' + this.getLocalizedSymbol() + ']';
    }

    @Override
    public String getIdentifier() {
        return this.unitId;
    }

    @Override
    public String getLocalizedSymbol() {
        return this.unitSymbol;
    }

    @Override
    public String getLocalizedDescription() {
        return this.unitDescription;
    }

    @Override
    public String[] getAltLocalizedNames() {
        return this.altNames;
    }

    protected boolean isCustom() {
        return false;
    }

    public ITypedQuantity<LinearUnit> asWellKnownQuantity() {
        return this.quantity(1L);
    }

    @Override
    protected String persistableStringFor(Number numericalValue) {
        return String.valueOf(numericalValue) + this.idSuffix;
    }

    @Override
    protected String localizedFormatFor(Number numericalValue, boolean useBreakingSpace, boolean allowCustomUnit) {
        NumberFormat formatter = LinearKindOfQuantity.getNumberFormat(useBreakingSpace);
        return formatter.format(numericalValue) + this.getAppendableSuffix(useBreakingSpace);
    }

    public ITypedQuantity<LinearUnit> customParseInteractive(String interactiveQuantity) throws QuantityConversionException {
        return this.kindOfQuantity.parseInteractive(interactiveQuantity, this.parseMap);
    }

    protected static class Custom
    extends LinearUnit {
        private final ScaleFactor factorToDefinition;
        private final LinearUnit definitionUnit;

        protected Custom(LinearKindOfQuantity kindOfQuantity, String unitId, ScaleFactor factorToDefinition, LinearUnit definitionUnit, String unitSymbol, String unitDesc, String ... altNames) {
            super(kindOfQuantity, unitId, definitionUnit.factorToAtom.concat(factorToDefinition), unitSymbol, unitDesc, altNames);
            this.factorToDefinition = factorToDefinition;
            this.definitionUnit = definitionUnit;
        }

        @Override
        protected boolean isCustom() {
            return true;
        }

        @Override
        public ITypedQuantity<LinearUnit> asWellKnownQuantity() {
            return this.definitionUnit.quantity(this.factorToDefinition.targetNumber(1L));
        }

        @Override
        protected String persistableStringFor(Number numericalValue) {
            return this.definitionUnit.persistableStringFor(this.factorToDefinition.targetNumber(numericalValue));
        }

        @Override
        protected String localizedFormatFor(Number numericalValue, boolean useBreakingSpace, boolean allowCustomUnit) {
            if (allowCustomUnit) {
                return super.localizedFormatFor(numericalValue, useBreakingSpace, allowCustomUnit);
            }
            return this.definitionUnit.localizedFormatFor(this.factorToDefinition.targetNumber(numericalValue), useBreakingSpace, false);
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

