/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.unit;

import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.DecimalScaleFactor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.IScalarAffineTransform;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.LongPostOffsetTransform;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ScalarQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.SimpleAffineTransform;

public class LongPreOffsetTransform
implements IScalarAffineTransform {
    final long preOffset;
    private final double multiplier;

    public LongPreOffsetTransform(long preOffset, double multiplier) {
        this.preOffset = preOffset;
        this.multiplier = multiplier;
    }

    @Override
    public Number getOffset() {
        return (double)this.preOffset * this.multiplier;
    }

    @Override
    public double getMultiplier() {
        return this.multiplier;
    }

    public boolean equals(Object other) {
        if (other instanceof LongPreOffsetTransform) {
            LongPreOffsetTransform otherPreOT = (LongPreOffsetTransform)other;
            return this.preOffset == otherPreOT.preOffset && this.multiplier == otherPreOT.multiplier;
        }
        return false;
    }

    public int hashCode() {
        long bits = Double.doubleToRawLongBits(this.preOffset) ^ Double.doubleToRawLongBits(this.multiplier);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public boolean targetOutOfRange(long srcNumericalValue, long maxAbsValue) {
        if (this.multiplier >= 1.0) {
            return (double)srcNumericalValue > (double)maxAbsValue / this.multiplier - (double)this.preOffset || (double)srcNumericalValue < (double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) / this.multiplier - (double)this.preOffset;
        }
        return this.targetValue(srcNumericalValue) > maxAbsValue || this.targetValue(srcNumericalValue) < (maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public boolean targetOutOfRange(double srcNumericalValue, long maxAbsValue) {
        if (this.multiplier >= 1.0) {
            return srcNumericalValue > (double)maxAbsValue / this.multiplier - (double)this.preOffset || srcNumericalValue < (double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) / this.multiplier - (double)this.preOffset;
        }
        return this.targetValue(srcNumericalValue) > (double)maxAbsValue || this.targetValue(srcNumericalValue) < (double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public long targetValue(long srcNumericalValue) {
        return Math.round((double)(srcNumericalValue + this.preOffset) * this.multiplier);
    }

    @Override
    public long targetFloor(long srcNumericalValue) {
        return (long)Math.floor((double)(srcNumericalValue + this.preOffset) * this.multiplier);
    }

    @Override
    public double targetFloor(double srcNumericalValue) {
        return Math.floor((srcNumericalValue + (double)this.preOffset) * this.multiplier);
    }

    @Override
    public int targetIntFloor(Number srcNumericalValue) {
        if (srcNumericalValue instanceof Long || srcNumericalValue instanceof ScalarQuantity.LongStored) {
            return (int)Math.floor((double)(srcNumericalValue.longValue() + this.preOffset) * this.multiplier);
        }
        return (int)this.targetFloor(srcNumericalValue.doubleValue());
    }

    @Override
    public Number targetNumber(long srcNumericalValue) {
        return (double)(srcNumericalValue + this.preOffset) * this.multiplier;
    }

    @Override
    public Number targetNumber(Number srcNumericalValue) {
        if (srcNumericalValue instanceof Long || srcNumericalValue instanceof ScalarQuantity.LongStored) {
            return this.targetNumber(srcNumericalValue.longValue());
        }
        return this.targetValue(srcNumericalValue.doubleValue());
    }

    @Override
    public double targetValue(double srcNumericalValue) {
        return (srcNumericalValue + (double)this.preOffset) * this.multiplier;
    }

    @Override
    public IScalarAffineTransform invert() {
        return new LongPostOffsetTransform(1.0 / this.multiplier, -this.preOffset);
    }

    @Override
    public boolean isUnity() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public IScalarAffineTransform concat(IScalarAffineTransform innerTransform) {
        if (innerTransform.isUnity()) {
            return this;
        }
        return SimpleAffineTransform.createWithPostOffset(this.multiplier * innerTransform.getMultiplier(), this.targetNumber(innerTransform.getOffset()));
    }

    @Override
    public IScalarAffineTransform invertAndConcat(IScalarAffineTransform innerTransform) {
        if (this.equals(innerTransform)) {
            return DecimalScaleFactor.get(0);
        }
        if (innerTransform.isUnity()) {
            return this.invert();
        }
        double invertedMultiplier = 1.0 / this.multiplier;
        double otherOffset = innerTransform.getOffset().doubleValue();
        return new SimpleAffineTransform(innerTransform.getMultiplier() * invertedMultiplier, otherOffset * invertedMultiplier - (double)this.preOffset);
    }
}

