/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.unit;

import java.text.MessageFormat;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.messages.internal.Messages;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.IPersister;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.IQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ITypedQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.LinearUnit;

public abstract class QuantityConversionException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected final Problem problem;
    protected final String badString;

    public static <T extends Comparable<T>> QuantityConversionException unparsable(String badString, T prototype, IPersister<T> persister) {
        return new Persisted(Problem.UNPARSEABLE, badString, prototype, persister);
    }

    public static <T extends Comparable<T>> QuantityConversionException noUnit(String badString, T prototype, IPersister<T> persister) {
        return new Persisted(Problem.NO_UNIT, badString, prototype, persister);
    }

    public static <T extends Comparable<T>> QuantityConversionException unknownUnit(String badString, T prototype, IPersister<T> persister) {
        return new Persisted(Problem.UNKNOWN_UNIT, badString, prototype, persister);
    }

    public static <T extends Comparable<T>> QuantityConversionException tooLow(T badValue, T min, IPersister<T> persister) {
        return new Persisted(Problem.TOO_LOW, badValue, min, persister);
    }

    public static <T extends Comparable<T>> QuantityConversionException tooHigh(T badValue, T max, IPersister<T> persister) {
        return new Persisted(Problem.TOO_HIGH, badValue, max, persister);
    }

    public static <T extends Comparable<T>> QuantityConversionException belowPrecision(T badValue, T precisionLimit, IPersister<T> persister) {
        return new Persisted(Problem.TOO_SMALL_MAGNITUDE, badValue, precisionLimit, persister);
    }

    public static QuantityConversionException unparsable(String badString, IQuantity prototype) {
        return new Quantity(Problem.UNPARSEABLE, badString, prototype);
    }

    public static QuantityConversionException noUnit(String badString, IQuantity prototype) {
        return new Quantity(Problem.NO_UNIT, badString, prototype);
    }

    public static QuantityConversionException unknownUnit(String badString, IQuantity prototype) {
        return new Quantity(Problem.UNKNOWN_UNIT, badString, prototype);
    }

    public static <Q extends IQuantity> QuantityConversionException tooLow(Q badValue, Q min) {
        return new Quantity(Problem.TOO_LOW, badValue, min);
    }

    public static <Q extends IQuantity> QuantityConversionException tooHigh(Q badValue, Q max) {
        return new Quantity(Problem.TOO_HIGH, badValue, max);
    }

    public static <Q extends IQuantity> QuantityConversionException belowPrecision(Q badValue, Q precisionLimit) {
        return new Quantity(Problem.TOO_SMALL_MAGNITUDE, badValue, precisionLimit);
    }

    public static QuantityConversionException conflictingConstraints(Object value, String key) {
        return new Quantity(Problem.CONFLICTING_CONSTRAINTS, key, (IQuantity)value);
    }

    protected QuantityConversionException(Problem problem, String badString) {
        this.problem = problem;
        this.badString = badString;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public String getBadString() {
        return this.badString;
    }

    public abstract String getPersistablePrototype();

    public abstract String getInteractivePrototype();

    @Override
    public String getMessage() {
        return MessageFormat.format(this.problem.logMsg, this.badString, this.getPersistablePrototype());
    }

    @Override
    public String getLocalizedMessage() {
        return MessageFormat.format(this.problem.localizedMsg, this.badString, this.getInteractivePrototype());
    }

    @Override
    public String toString() {
        String s = this.getClass().getName();
        String message = this.getMessage();
        return message != null ? s + ": " + message : s;
    }

    public static class Quantity
    extends QuantityConversionException {
        private static final long serialVersionUID = 1L;
        protected final IQuantity badQuantity;
        protected final IQuantity prototype;

        public Quantity(Problem problem, String badString, IQuantity prototype) {
            super(problem, badString);
            this.badQuantity = null;
            this.prototype = prototype;
        }

        public Quantity(Problem problem, IQuantity badQuantity, IQuantity prototype) {
            super(problem, null);
            this.badQuantity = badQuantity;
            this.prototype = prototype;
        }

        @Override
        public String getMessage() {
            if (this.badQuantity != null) {
                return MessageFormat.format(this.problem.logMsg, this.badQuantity.persistableString(), this.getPersistablePrototype());
            }
            return super.getMessage();
        }

        @Override
        public String getLocalizedMessage() {
            if (this.badQuantity != null) {
                if (this.badQuantity.getUnit() instanceof LinearUnit) {
                    ITypedQuantity typedProto = (ITypedQuantity)this.prototype;
                    String protoString = Quantity.readableProto(typedProto, (LinearUnit)this.badQuantity.getUnit());
                    return MessageFormat.format(this.problem.localizedMsg, this.badQuantity.displayUsing("exact"), protoString);
                }
                return MessageFormat.format(this.problem.localizedMsg, this.badQuantity.displayUsing("exact"), this.prototype.displayUsing("exact"));
            }
            return super.getLocalizedMessage();
        }

        private static String readableProto(ITypedQuantity<LinearUnit> prototype, LinearUnit userUnit) {
            LinearUnit exactUnit = (LinearUnit)prototype.getUnit();
            StringBuilder out = new StringBuilder(prototype.displayUsing("exact"));
            if (!userUnit.equals(exactUnit)) {
                LinearKindOfQuantity kindOfQuantity = exactUnit.getContentType();
                LinearUnit autoUnit = kindOfQuantity.getPreferredUnit(prototype, 1.0, 1000.0);
                if (!userUnit.equals(autoUnit)) {
                    out.append(" \u2248 ");
                    out.append(LinearKindOfQuantity.AutoFormatter.formatInUnit(prototype, userUnit, 3));
                }
                out.append(" \u2248 ");
                out.append(LinearKindOfQuantity.AutoFormatter.formatInUnit(prototype, autoUnit, 3));
            }
            return out.toString();
        }

        @Override
        public String getPersistablePrototype() {
            return this.prototype.persistableString();
        }

        @Override
        public String getInteractivePrototype() {
            return this.prototype.interactiveFormat();
        }
    }

    public static class Persisted
    extends QuantityConversionException {
        private static final long serialVersionUID = 1L;
        protected final Object badValue;
        protected final Object prototype;
        protected final transient IPersister<?> persister;

        private Persisted(Problem problem, String badString, Object prototype, IPersister<?> persister) {
            super(problem, badString);
            this.badValue = null;
            this.prototype = prototype;
            this.persister = persister;
        }

        private Persisted(Problem problem, Object badValue, Object prototype, IPersister<?> persister) {
            super(problem, null);
            this.badValue = badValue;
            this.prototype = prototype;
            this.persister = persister;
        }

        private <T> String persistable(T value) {
            return this.persister.persistableString(value);
        }

        private <T> String interactive(T value) {
            return this.persister.interactiveFormat(value);
        }

        @Override
        public String getMessage() {
            if (this.badValue != null) {
                return MessageFormat.format(this.problem.logMsg, this.persistable(this.badValue), this.getPersistablePrototype());
            }
            return super.getMessage();
        }

        @Override
        public String getLocalizedMessage() {
            if (this.badValue != null) {
                return MessageFormat.format(this.problem.localizedMsg, this.interactive(this.badValue), this.getInteractivePrototype());
            }
            return super.getLocalizedMessage();
        }

        @Override
        public String getPersistablePrototype() {
            return this.persistable(this.prototype);
        }

        @Override
        public String getInteractivePrototype() {
            return this.interactive(this.prototype);
        }
    }

    public static enum Problem {
        UNPARSEABLE("Unparsable {0}, expected {1}", "QuantityConversionException_UNPARSEABLE_MSG"),
        NO_UNIT("No unit in {0}, expected {1}", "QuantityConversionException_NO_UNIT_MSG"),
        UNKNOWN_UNIT("Unknown unit in {0}, expected {1}", "QuantityConversionException_UNKNOWN_UNIT_MSG"),
        TOO_LOW("Value {0} too low, min is {1}", "QuantityConversionException_TOO_LOW_MSG"),
        TOO_HIGH("Value {0} too high, max is {1}", "QuantityConversionException_TOO_HIGH_MSG"),
        TOO_SMALL_MAGNITUDE("Value {0} below precision, smallest unit is {1}", "QuantityConversionException_TOO_SMALL_MAGNITUDE_MSG"),
        CONFLICTING_CONSTRAINTS("Constraints for value {1} and key {0} do not match.", "QuantityConversionException_CONSTRAINTS_DO_NOT_MATCH");

        public final String logMsg;
        public final String localizedMsg;

        private Problem(String logMsg, String localizedMsgKey) {
            this.logMsg = logMsg;
            this.localizedMsg = Messages.getString(localizedMsgKey);
        }
    }
}

