/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.unit;

import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.DecimalScaleFactor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.IScalarAffineTransform;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.LongPostOffsetTransform;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.LongPreOffsetTransform;

public class SimpleAffineTransform
implements IScalarAffineTransform {
    private static final long DOUBLE_EXACT_LIMIT = 0L;
    private final double multiplier;
    private final double offset;

    public static IScalarAffineTransform createWithPostOffset(double multiplier, Number offset) {
        if (offset instanceof Long && offset.longValue() >= 0L) {
            return new LongPostOffsetTransform(multiplier, offset.longValue());
        }
        return new SimpleAffineTransform(multiplier, offset.doubleValue());
    }

    public static IScalarAffineTransform createWithPreOffset(double multiplier, Number offset) {
        if (offset instanceof Long) {
            return new LongPreOffsetTransform(offset.longValue(), multiplier);
        }
        return new SimpleAffineTransform(multiplier, offset.doubleValue() * multiplier);
    }

    public static IScalarAffineTransform createWithNegPreOffset(double multiplier, Number negativeOffset) {
        if (negativeOffset instanceof Long) {
            return new LongPreOffsetTransform(-negativeOffset.longValue(), multiplier);
        }
        return new SimpleAffineTransform(multiplier, -negativeOffset.doubleValue() * multiplier);
    }

    public SimpleAffineTransform(double multiplier, double offset) {
        this.multiplier = multiplier;
        this.offset = offset;
    }

    @Override
    public Number getOffset() {
        return this.offset;
    }

    @Override
    public double getMultiplier() {
        return this.multiplier;
    }

    public boolean equals(Object other) {
        if (other instanceof SimpleAffineTransform) {
            SimpleAffineTransform otherSAT = (SimpleAffineTransform)other;
            return this.multiplier == otherSAT.multiplier && this.offset == otherSAT.offset;
        }
        return false;
    }

    public int hashCode() {
        long bits = Double.doubleToRawLongBits(this.multiplier) ^ Double.doubleToRawLongBits(this.offset);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public boolean targetOutOfRange(long srcNumericalValue, long maxAbsValue) {
        if (this.multiplier >= 1.0) {
            return (double)srcNumericalValue > ((double)maxAbsValue - this.offset) / this.multiplier || (double)srcNumericalValue < ((double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) - this.offset) / this.multiplier;
        }
        return this.targetValue(srcNumericalValue) > maxAbsValue || this.targetValue(srcNumericalValue) < (maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public boolean targetOutOfRange(double srcNumericalValue, long maxAbsValue) {
        if (this.multiplier >= 1.0) {
            return srcNumericalValue > ((double)maxAbsValue - this.offset) / this.multiplier || srcNumericalValue < ((double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) - this.offset) / this.multiplier;
        }
        return this.targetValue(srcNumericalValue) > (double)maxAbsValue || this.targetValue(srcNumericalValue) < (double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public long targetValue(long srcNumericalValue) {
        return Math.round((double)srcNumericalValue * this.multiplier + this.offset);
    }

    @Override
    public long targetFloor(long srcNumericalValue) {
        return (long)Math.floor((double)srcNumericalValue * this.multiplier + this.offset);
    }

    @Override
    public double targetFloor(double srcNumericalValue) {
        return Math.floor(srcNumericalValue * this.multiplier + this.offset);
    }

    @Override
    public int targetIntFloor(Number srcNumericalValue) {
        return (int)this.targetFloor(srcNumericalValue.doubleValue());
    }

    @Override
    public Number targetNumber(long srcNumericalValue) {
        return this.targetValue((double)srcNumericalValue);
    }

    @Override
    public Number targetNumber(Number srcNumericalValue) {
        return this.targetValue(srcNumericalValue.doubleValue());
    }

    @Override
    public double targetValue(double srcNumericalValue) {
        return srcNumericalValue * this.multiplier + this.offset;
    }

    @Override
    public IScalarAffineTransform invert() {
        return new SimpleAffineTransform(1.0 / this.multiplier, -this.offset / this.multiplier);
    }

    @Override
    public boolean isUnity() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public IScalarAffineTransform concat(IScalarAffineTransform innerTransform) {
        return SimpleAffineTransform.createWithPostOffset(this.multiplier * innerTransform.getMultiplier(), this.targetNumber(innerTransform.getOffset()));
    }

    @Override
    public IScalarAffineTransform invertAndConcat(IScalarAffineTransform innerTransform) {
        if (this.equals(innerTransform)) {
            return DecimalScaleFactor.get(0);
        }
        double invertedMultiplier = 1.0 / this.multiplier;
        double otherOffset = innerTransform.getOffset().doubleValue();
        return new SimpleAffineTransform(innerTransform.getMultiplier() * invertedMultiplier, (otherOffset - this.offset) * invertedMultiplier);
    }
}

