/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.unit;

import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.messages.internal.Messages;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.DecimalScaleFactor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.IScalarAffineTransform;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ITypedQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.KindOfQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.LinearUnit;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ScalarQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ScaleFactor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.TimestampKind;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.TypedUnit;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.UnitLookup;

public class TimestampUnit
extends TypedUnit<TimestampUnit> {
    private final LinearUnit timeOffsetUnit;
    private final String unitId;
    private final AtomicReference<String> unitDescriptionRef;

    TimestampUnit(LinearUnit timeOffsetUnit) {
        this.timeOffsetUnit = timeOffsetUnit;
        this.unitId = "epoch" + timeOffsetUnit.getIdentifier();
        this.unitDescriptionRef = new AtomicReference();
    }

    @Override
    protected final Class<TimestampUnit> getUnitClass() {
        return TimestampUnit.class;
    }

    @Override
    public LinearUnit getDeltaUnit() {
        return this.timeOffsetUnit;
    }

    @Override
    protected TimestampUnit getScaledUnit(LinearUnit deltaUnit) {
        return deltaUnit == this.timeOffsetUnit ? this : new TimestampUnit(deltaUnit);
    }

    @Override
    public KindOfQuantity<TimestampUnit> getContentType() {
        return TimestampKind.INSTANCE;
    }

    @Override
    public ITypedQuantity<TimestampUnit> quantity(Number numericalValue) {
        return new ScalarQuantity.LongStored<TimestampUnit>(numericalValue.longValue(), this);
    }

    @Override
    public ITypedQuantity<TimestampUnit> quantity(long numericalValue) {
        return new ScalarQuantity.LongStored<TimestampUnit>(numericalValue, this);
    }

    @Override
    public ITypedQuantity<TimestampUnit> quantity(double numericalValue) {
        return new ScalarQuantity.LongStored<TimestampUnit>((long)numericalValue, this);
    }

    @Override
    public IScalarAffineTransform valueTransformTo(TimestampUnit targetUnit) {
        if (targetUnit.getContentType() != this.getContentType()) {
            throw new IllegalArgumentException("Cannot convert from unit " + this + " into unit of type " + targetUnit.getContentType().getIdentifier());
        }
        return this.timeOffsetUnit.valueTransformTo(targetUnit.timeOffsetUnit);
    }

    @Override
    public boolean isLinear() {
        return false;
    }

    @Override
    protected ITypedQuantity<TimestampUnit> add(long numericalAugend, LinearUnit addendUnit, long numericalAddend) {
        int comparision = this.getDeltaUnit().compareTo(addendUnit);
        if (comparision == 0) {
            long sum = numericalAugend + numericalAddend;
            if (((numericalAugend ^ sum) & (numericalAddend ^ sum)) >= 0L) {
                return this.quantity(numericalAugend + numericalAddend);
            }
            return this.quantity((double)numericalAugend + (double)numericalAddend);
        }
        if (comparision < 0) {
            return this.addPossiblyIntegral(numericalAugend, addendUnit.valueTransformTo(this.getDeltaUnit()), numericalAddend);
        }
        return this.getScaledUnit(addendUnit).addPossiblyIntegral(numericalAddend, this.getDeltaUnit().valueTransformTo(addendUnit), numericalAugend);
    }

    @Override
    protected ITypedQuantity<LinearUnit> subtractSame(long numericalMinuend, TimestampUnit subtrahendUnit, long numericalSubtrahend) {
        int comparision = this.getDeltaUnit().compareTo(subtrahendUnit.getDeltaUnit());
        if (comparision == 0) {
            long sum = numericalMinuend - numericalSubtrahend;
            if (((numericalMinuend ^ sum) & (-numericalSubtrahend ^ sum)) >= 0L) {
                return this.getDeltaUnit().quantity(numericalMinuend - numericalSubtrahend);
            }
            return this.getDeltaUnit().quantity((double)numericalMinuend - (double)numericalSubtrahend);
        }
        if (comparision < 0) {
            return this.getDeltaUnit().addPossiblyIntegral(numericalMinuend, subtrahendUnit.valueTransformTo(this), -numericalSubtrahend);
        }
        return subtrahendUnit.getDeltaUnit().addPossiblyIntegral(-numericalSubtrahend, this.valueTransformTo(subtrahendUnit), numericalMinuend);
    }

    @Override
    protected ITypedQuantity<TimestampUnit> floorQuantize(long numericalValue, ITypedQuantity<LinearUnit> quanta) {
        ITypedQuantity<LinearUnit> offset = this.timeOffsetUnit.floorQuantize(numericalValue, quanta);
        int comparision = this.getDeltaUnit().compareTo((LinearUnit)offset.getUnit());
        if (comparision == 0) {
            return this.quantity(offset.longValue());
        }
        if (comparision < 0) {
            return this.quantity(offset.clampedLongValueIn(this.getDeltaUnit()));
        }
        if (UnitLookup.NANOSECOND.compareTo((LinearUnit)offset.getUnit()) >= 0) {
            return UnitLookup.EPOCH_NS.quantity(offset.clampedLongValueIn(UnitLookup.NANOSECOND));
        }
        return this.getScaledUnit((LinearUnit)offset.getUnit()).quantity(offset.longValue());
    }

    @Override
    protected ITypedQuantity<TimestampUnit> floorQuantize(double numericalValue, ITypedQuantity<LinearUnit> quanta) {
        ITypedQuantity<LinearUnit> offset = this.timeOffsetUnit.floorQuantize(numericalValue, quanta);
        int comparision = this.getDeltaUnit().compareTo((LinearUnit)offset.getUnit());
        if (comparision == 0) {
            return this.quantity(offset.longValue());
        }
        if (comparision < 0) {
            return this.quantity(offset.clampedLongValueIn(this.getDeltaUnit()));
        }
        if (UnitLookup.NANOSECOND.compareTo((LinearUnit)offset.getUnit()) >= 0) {
            return UnitLookup.EPOCH_NS.quantity(offset.clampedLongValueIn(UnitLookup.NANOSECOND));
        }
        return this.getScaledUnit((LinearUnit)offset.getUnit()).quantity(offset.longValue());
    }

    public String toString() {
        return this.getIdentifier();
    }

    @Override
    public String getIdentifier() {
        return this.unitId;
    }

    @Override
    public String getLocalizedSymbol() {
        return "";
    }

    @Override
    public String getAppendableSuffix(boolean useBreakingSpace) {
        return "";
    }

    @Override
    public String getLocalizedDescription() {
        this.unitDescriptionRef.compareAndSet(null, MessageFormat.format(Messages.getString("TimestampKind_SINCE_1970_MSG"), this.timeOffsetUnit.asWellKnownQuantity().displayUsing("exact")));
        return this.unitDescriptionRef.get();
    }

    @Override
    public String[] getAltLocalizedNames() {
        return EMPTY_STRING_ARRAY;
    }

    private long floorValueIn(long numericalValue, TimestampUnit targetUnit) {
        return this.valueTransformTo(targetUnit).targetFloor(numericalValue);
    }

    @Override
    protected String localizedFormatFor(Number numericalValue, boolean useBreakingSpace, boolean allowCustomUnit) {
        StringBuffer out = new StringBuffer();
        long seconds = this.floorValueIn(numericalValue.longValue(), TimestampKind.SECONDS_UNIT);
        Date date = new Date(seconds * 1000L);
        DateFormat formatter = TimestampKind.getDateTimeFormatter();
        FieldPosition secondPos = new FieldPosition(7);
        formatter.format(date, out, secondPos);
        if (!this.equals(TimestampKind.SECONDS_UNIT)) {
            DecimalScaleFactor decimalFactor;
            ScaleFactor restFactor = (ScaleFactor)TimestampKind.SECONDS_UNIT.valueTransformTo(this);
            long rest = numericalValue.longValue() - restFactor.targetFloor(seconds);
            int fractionPos = useBreakingSpace ? out.length() : secondPos.getEndIndex();
            out.insert(fractionPos++, DecimalFormatSymbols.getInstance().getDecimalSeparator());
            if (restFactor instanceof DecimalScaleFactor) {
                decimalFactor = (DecimalScaleFactor)restFactor;
            } else {
                decimalFactor = (DecimalScaleFactor)TimestampKind.SECONDS_UNIT.valueTransformTo(TimestampKind.NANOS_UNIT);
                rest = this.floorValueIn(rest, TimestampKind.NANOS_UNIT);
            }
            String restStr = Long.toString(rest);
            out.insert(fractionPos, restStr);
            out.insert(fractionPos, "000000000000000000000000", restStr.length(), decimalFactor.powerOf10);
            return out.toString();
        }
        if (useBreakingSpace) {
            return out.toString().replace('\u00a0', ' ');
        }
        return out.toString();
    }

    @Override
    protected String persistableStringFor(Number numericalValue) {
        return numericalValue.toString() + ' ' + this.getIdentifier();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TimestampUnit) {
            TimestampUnit otherUnit = (TimestampUnit)other;
            return otherUnit.timeOffsetUnit.equals(this.timeOffsetUnit);
        }
        return false;
    }

    public int hashCode() {
        return this.timeOffsetUnit.hashCode();
    }
}

