/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.collection.SimpleArray;

public class SortedHead<T> {
    private final T[] head;
    private final T[] candidates;
    private int candidateCount;
    private T limit;
    private final Comparator<? super T> comparator;
    private final SimpleArray<T> tail;

    private SortedHead(T[] head, SimpleArray<T> tail, Comparator<? super T> comparator) {
        if (head.length < 1) {
            throw new IllegalArgumentException("Cannot use SortedHead with 0 size");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Comparator is null");
        }
        Arrays.sort(head, comparator);
        this.candidates = (Object[])head.clone();
        this.limit = head[head.length - 1];
        this.tail = tail;
        this.head = head;
        this.comparator = comparator;
    }

    public SortedHead(T[] head, Comparator<? super T> comparator) {
        this(head, new SimpleArray<Object>((Object[])head.clone()), comparator);
    }

    public T[] getTail() {
        this.updateHead();
        return this.tail.elements();
    }

    public void addObject(T o) {
        boolean isBeforeLimit;
        boolean bl = isBeforeLimit = this.comparator.compare(o, this.limit) < 0;
        if (isBeforeLimit && this.candidateCount >= this.candidates.length) {
            this.updateHead();
            boolean bl2 = isBeforeLimit = this.comparator.compare(o, this.limit) < 0;
        }
        if (isBeforeLimit) {
            this.candidates[this.candidateCount++] = o;
        } else {
            this.tail.add(o);
        }
    }

    private void updateHead() {
        int i;
        Arrays.sort(this.candidates, 0, this.candidateCount, this.comparator);
        Object[] tmp = (Object[])this.head.clone();
        int p = 0;
        int q = 0;
        for (i = 0; i < this.head.length; ++i) {
            if (p < this.candidateCount) {
                T c = this.candidates[p];
                Object s = tmp[q];
                if (this.comparator.compare(c, s) < 0) {
                    this.head[i] = c;
                    ++p;
                    continue;
                }
                this.head[i] = s;
                ++q;
                continue;
            }
            int left = this.head.length - i;
            System.arraycopy(tmp, q, this.head, i, left);
            q += left;
            break;
        }
        for (i = p; i < this.candidateCount; ++i) {
            this.tail.add(this.candidates[i]);
        }
        for (i = q; i < this.head.length; ++i) {
            this.tail.add(tmp[i]);
        }
        this.limit = this.head[this.head.length - 1];
        this.candidateCount = 0;
    }

    public static <T> void addSorted(Iterator<? extends T> sourceIterator, T[] fullHead, SimpleArray<T> tail, Comparator<? super T> comparator) {
        SortedHead<T> sorter = new SortedHead<T>(fullHead, tail, comparator);
        while (sourceIterator.hasNext()) {
            sorter.addObject(sourceIterator.next());
        }
        super.updateHead();
    }
}

