/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0;

import java.io.UnsupportedEncodingException;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ContentType;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.UnitLookup;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.IValueReader;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;

final class StringReader
implements IValueReader {
    public static final StringReader INSTANCE = new StringReader();
    private static final int STRING_ELEMENT_SIZE = 2;
    private static final String CHARSET = "UTF-16";
    private static final int UNREASONABLE_STRING_LENGTH = 100000000;

    StringReader() {
    }

    @Override
    public Object readValue(byte[] data, Offset offset, long timestamp) throws InvalidJfrFileException {
        return StringReader.readString(data, offset);
    }

    public static String readString(byte[] data, Offset offset) throws InvalidJfrFileException {
        int byteCount = StringReader.readStringByteCount(data, offset);
        int index = offset.get();
        offset.increase(byteCount);
        try {
            return new String(data, index, byteCount, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static int readStringByteCount(byte[] data, Offset offset) throws InvalidJfrFileException {
        int numberOfStringElements = NumberReaders.readInt(data, offset);
        if (numberOfStringElements < 0 || numberOfStringElements > 100000000) {
            throw new InvalidJfrFileException();
        }
        return numberOfStringElements * 2;
    }

    @Override
    public ContentType<?> getValueType() {
        return UnitLookup.PLAIN_TEXT;
    }
}

