/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.factories;

import org.qubership.profiler.shaded.org.openjdk.jmc.common.IMCThread;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ContentType;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.UnitLookup;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.factories.IPoolFactory;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.factories.JfrThread;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.factories.ThreadGroup;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;

final class JavaThreadFactory
implements IPoolFactory<IMCThread> {
    private final int m_osThread;
    private final int m_threadGroup;

    public JavaThreadFactory(ValueDescriptor[] descriptors) {
        this.m_osThread = ValueDescriptor.getIndex(descriptors, "thread");
        this.m_threadGroup = ValueDescriptor.getIndex(descriptors, "group");
    }

    @Override
    public IMCThread createObject(long identifier, Object o) {
        if (o != null) {
            Object[] objects = (Object[])o;
            JfrThread thread = (JfrThread)objects[this.m_osThread];
            ThreadGroup group = (ThreadGroup)objects[this.m_threadGroup];
            if (group != null) {
                thread.addThreadGroup(group);
            }
            thread.addJavaId(identifier);
            return thread;
        }
        return null;
    }

    @Override
    public ContentType<IMCThread> getContentType() {
        return UnitLookup.THREAD;
    }
}

