/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.stacktrace.graph;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IMCFrame;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IMCStackTrace;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IAttribute;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IItem;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IItemCollection;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IItemIterable;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IMemberAccessor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.IQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.stacktrace.graph.AggregatableFrame;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.stacktrace.graph.Edge;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.stacktrace.graph.GraphModelUtils;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.stacktrace.graph.Node;

public final class StacktraceGraphModel {
    private final FrameSeparator frameSeparator;
    private final IItemCollection items;
    private final IAttribute<IQuantity> attribute;
    private int totalTraceCount;
    private int totalEdgeCount;
    private int nodeCounter;
    private final Map<Integer, Set<Edge>> edges = new HashMap<Integer, Set<Edge>>(1024);
    private final Map<AggregatableFrame, Node> nodes = new HashMap<AggregatableFrame, Node>(1024);

    public StacktraceGraphModel(FrameSeparator frameSeparator, IItemCollection items, IAttribute<IQuantity> attribute) {
        this.frameSeparator = frameSeparator;
        this.items = items;
        this.attribute = attribute;
        this.buildModel();
    }

    public Collection<Edge> getEdges() {
        return this.edges.values().stream().flatMap(c -> c.stream()).collect(Collectors.toSet());
    }

    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public IAttribute<IQuantity> getAttribute() {
        return this.attribute;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public IItemCollection getItems() {
        return this.items;
    }

    public int getTotalEdgeCount() {
        return this.totalEdgeCount;
    }

    public int getTotalTraceCount() {
        return this.totalTraceCount;
    }

    public int findNodeMinCount() {
        int minCount = Integer.MAX_VALUE;
        for (Node n : this.getNodes()) {
            minCount = Math.min(n.getCount(), minCount);
        }
        return minCount;
    }

    public int findNodeMaxCount() {
        int maxCount = 0;
        for (Node n : this.getNodes()) {
            maxCount = Math.max(n.getCount(), maxCount);
        }
        return maxCount;
    }

    public double findNodeMinWeight() {
        double minWeight = Double.MAX_VALUE;
        for (Node n : this.getNodes()) {
            minWeight = Math.min(n.getWeight(), minWeight);
        }
        return minWeight;
    }

    public double findNodeMaxWeight() {
        double maxWeight = 0.0;
        for (Node n : this.getNodes()) {
            maxWeight = Math.max(n.getWeight(), maxWeight);
        }
        return maxWeight;
    }

    public double findEdgeMinValue() {
        double minValue = Double.MAX_VALUE;
        for (Edge e : this.getEdges()) {
            minValue = Math.min(e.getValue(), minValue);
        }
        return minValue;
    }

    public double findEdgeMaxValue() {
        double maxValue = 0.0;
        for (Edge e : this.getEdges()) {
            maxValue = Math.max(e.getValue(), maxValue);
        }
        return maxValue;
    }

    public int findEdgeMinCount() {
        int minValue = Integer.MAX_VALUE;
        for (Edge e : this.getEdges()) {
            minValue = Math.min(e.getCount(), minValue);
        }
        return minValue;
    }

    public int findEdgeMaxCount() {
        int maxValue = 0;
        for (Edge e : this.getEdges()) {
            maxValue = Math.max(e.getCount(), maxValue);
        }
        return maxValue;
    }

    public String toString() {
        return String.format("=== StackTraceModel ===\nNode Count:%d\nEdge Count:%d\nNodes: %s\nEdges: %s\n========================", this.nodes.size(), this.edges.size(), this.nodes.toString(), this.edges.toString());
    }

    private void buildModel() {
        for (IItemIterable iterable : this.items) {
            IMemberAccessor<IMCStackTrace, IItem> stacktraceAccessor = StacktraceGraphModel.getAccessor(iterable, JfrAttributes.EVENT_STACKTRACE);
            if (stacktraceAccessor == null) continue;
            iterable.forEach(item -> this.addItem((IItem)item, stacktraceAccessor, StacktraceGraphModel.getAccessor(iterable, this.attribute)));
        }
    }

    private static <T> IMemberAccessor<T, IItem> getAccessor(IItemIterable iterable, IAttribute<T> attr) {
        return attr != null ? iterable.getType().getAccessor(attr.getKey()) : null;
    }

    private void addItem(IItem item, IMemberAccessor<IMCStackTrace, IItem> stackTraceAccessor, IMemberAccessor<IQuantity, IItem> quantityAccessor) {
        IMCStackTrace stackTrace = stackTraceAccessor.getMember(item);
        if (stackTrace == null) {
            return;
        }
        List<? extends IMCFrame> frames = stackTrace.getFrames();
        if (frames.isEmpty()) {
            return;
        }
        double value = 0.0;
        if (quantityAccessor != null) {
            value = quantityAccessor.getMember(item).doubleValue();
        }
        IMCFrame firstFrame = frames.get(0);
        Node n = this.getOrCreateNode(firstFrame);
        ++this.totalTraceCount;
        ++n.count;
        n.weight += value;
        for (int i = frames.size() - 1; i > 0; --i) {
            IMCFrame currentFrame = frames.get(i);
            IMCFrame nextFrame = frames.get(i - 1);
            Node currentNode = this.getOrCreateNode(currentFrame);
            Node nextNode = this.getOrCreateNode(nextFrame);
            ++currentNode.cumulativeCount;
            ++nextNode.cumulativeCount;
            currentNode.cumulativeWeight += value;
            nextNode.cumulativeWeight += value;
            Edge e = this.getOrCreateLink(currentNode, nextNode);
            ++e.count;
            ++this.totalEdgeCount;
        }
    }

    private Node getOrCreateNode(IMCFrame frame) {
        AggregatableFrame aframe = new AggregatableFrame(this.frameSeparator, frame);
        Node n = this.nodes.get(aframe);
        if (n == null) {
            n = new Node(this.nodeCounter++, aframe);
            this.nodes.put(aframe, n);
        }
        return n;
    }

    private Edge getOrCreateLink(Node fromNode, Node toNode) {
        if (!this.edges.containsKey(fromNode.getNodeId())) {
            Edge edge = new Edge(fromNode, toNode);
            HashSet<Edge> newEdgeSet = new HashSet<Edge>();
            newEdgeSet.add(edge);
            this.edges.put(fromNode.getNodeId(), newEdgeSet);
            return edge;
        }
        Set<Edge> toSet = this.edges.get(fromNode.getNodeId());
        for (Edge edge : toSet) {
            if (!edge.getTo().equals(toNode)) continue;
            return edge;
        }
        Edge edge = new Edge(fromNode, toNode);
        toSet.add(edge);
        return edge;
    }

    public static void main(String[] args) throws IOException, CouldNotLoadRecordingException {
        IItemCollection items = JfrLoaderToolkit.loadEvents(new File(args[0]));
        IItemCollection filteredItems = items.apply(JdkFilters.EXECUTION_SAMPLE);
        FrameSeparator frameSeparator = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);
        StacktraceGraphModel model = new StacktraceGraphModel(frameSeparator, filteredItems, null);
        System.out.println(GraphModelUtils.printGraph(model));
    }
}

