/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.aop.framework;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.qubership.profiler.shaded.org.aopalliance.intercept.MethodInterceptor;
import org.qubership.profiler.shaded.org.springframework.aop.Advisor;
import org.qubership.profiler.shaded.org.springframework.aop.IntroductionAdvisor;
import org.qubership.profiler.shaded.org.springframework.aop.MethodMatcher;
import org.qubership.profiler.shaded.org.springframework.aop.PointcutAdvisor;
import org.qubership.profiler.shaded.org.springframework.aop.framework.Advised;
import org.qubership.profiler.shaded.org.springframework.aop.framework.AdvisorChainFactory;
import org.qubership.profiler.shaded.org.springframework.aop.framework.InterceptorAndDynamicMethodMatcher;
import org.qubership.profiler.shaded.org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.qubership.profiler.shaded.org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import org.qubership.profiler.shaded.org.springframework.aop.support.MethodMatchers;

public class DefaultAdvisorChainFactory
implements AdvisorChainFactory,
Serializable {
    @Override
    public List<Object> getInterceptorsAndDynamicInterceptionAdvice(Advised config, Method method, Class<?> targetClass) {
        ArrayList<Object> interceptorList = new ArrayList<Object>(config.getAdvisors().length);
        Class<?> actualClass = targetClass != null ? targetClass : method.getDeclaringClass();
        boolean hasIntroductions = DefaultAdvisorChainFactory.hasMatchingIntroductions(config, actualClass);
        AdvisorAdapterRegistry registry = GlobalAdvisorAdapterRegistry.getInstance();
        for (Advisor advisor : config.getAdvisors()) {
            MethodInterceptor[] interceptors;
            if (advisor instanceof PointcutAdvisor) {
                PointcutAdvisor pointcutAdvisor = (PointcutAdvisor)advisor;
                if (!config.isPreFiltered() && !pointcutAdvisor.getPointcut().getClassFilter().matches(actualClass)) continue;
                interceptors = registry.getInterceptors(advisor);
                MethodMatcher mm = pointcutAdvisor.getPointcut().getMethodMatcher();
                if (!MethodMatchers.matches(mm, method, actualClass, hasIntroductions)) continue;
                if (mm.isRuntime()) {
                    for (MethodInterceptor interceptor : interceptors) {
                        interceptorList.add(new InterceptorAndDynamicMethodMatcher(interceptor, mm));
                    }
                    continue;
                }
                interceptorList.addAll(Arrays.asList(interceptors));
                continue;
            }
            if (advisor instanceof IntroductionAdvisor) {
                IntroductionAdvisor ia = (IntroductionAdvisor)advisor;
                if (!config.isPreFiltered() && !ia.getClassFilter().matches(actualClass)) continue;
                interceptors = registry.getInterceptors(advisor);
                interceptorList.addAll(Arrays.asList(interceptors));
                continue;
            }
            MethodInterceptor[] interceptors2 = registry.getInterceptors(advisor);
            interceptorList.addAll(Arrays.asList(interceptors2));
        }
        return interceptorList;
    }

    private static boolean hasMatchingIntroductions(Advised config, Class<?> actualClass) {
        for (int i = 0; i < config.getAdvisors().length; ++i) {
            IntroductionAdvisor ia;
            Advisor advisor = config.getAdvisors()[i];
            if (!(advisor instanceof IntroductionAdvisor) || !(ia = (IntroductionAdvisor)advisor).getClassFilter().matches(actualClass)) continue;
            return true;
        }
        return false;
    }
}

