/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.aop.framework;

import java.io.Serializable;
import java.lang.reflect.Proxy;
import org.qubership.profiler.shaded.org.springframework.aop.SpringProxy;
import org.qubership.profiler.shaded.org.springframework.aop.framework.AdvisedSupport;
import org.qubership.profiler.shaded.org.springframework.aop.framework.AopConfigException;
import org.qubership.profiler.shaded.org.springframework.aop.framework.AopProxy;
import org.qubership.profiler.shaded.org.springframework.aop.framework.AopProxyFactory;
import org.qubership.profiler.shaded.org.springframework.aop.framework.JdkDynamicAopProxy;
import org.qubership.profiler.shaded.org.springframework.aop.framework.ObjenesisCglibAopProxy;

public class DefaultAopProxyFactory
implements AopProxyFactory,
Serializable {
    @Override
    public AopProxy createAopProxy(AdvisedSupport config) throws AopConfigException {
        if (config.isOptimize() || config.isProxyTargetClass() || this.hasNoUserSuppliedProxyInterfaces(config)) {
            Class<?> targetClass = config.getTargetClass();
            if (targetClass == null) {
                throw new AopConfigException("TargetSource cannot determine target class: Either an interface or a target is required for proxy creation.");
            }
            if (targetClass.isInterface() || Proxy.isProxyClass(targetClass)) {
                return new JdkDynamicAopProxy(config);
            }
            return new ObjenesisCglibAopProxy(config);
        }
        return new JdkDynamicAopProxy(config);
    }

    private boolean hasNoUserSuppliedProxyInterfaces(AdvisedSupport config) {
        Class<?>[] ifcs = config.getProxiedInterfaces();
        return ifcs.length == 0 || ifcs.length == 1 && SpringProxy.class.isAssignableFrom(ifcs[0]);
    }
}

