/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.beans.factory.config;

import org.qubership.profiler.shaded.org.springframework.beans.BeanMetadataElement;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;
import org.qubership.profiler.shaded.org.springframework.util.ObjectUtils;

public class TypedStringValue
implements BeanMetadataElement {
    private String value;
    private volatile Object targetType;
    private Object source;
    private String specifiedTypeName;
    private volatile boolean dynamic;

    public TypedStringValue(String value) {
        this.setValue(value);
    }

    public TypedStringValue(String value, Class<?> targetType) {
        this.setValue(value);
        this.setTargetType(targetType);
    }

    public TypedStringValue(String value, String targetTypeName) {
        this.setValue(value);
        this.setTargetTypeName(targetTypeName);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setTargetType(Class<?> targetType) {
        Assert.notNull(targetType, "'targetType' must not be null");
        this.targetType = targetType;
    }

    public Class<?> getTargetType() {
        Object targetTypeValue = this.targetType;
        if (!(targetTypeValue instanceof Class)) {
            throw new IllegalStateException("Typed String value does not carry a resolved target type");
        }
        return (Class)targetTypeValue;
    }

    public void setTargetTypeName(String targetTypeName) {
        Assert.notNull(targetTypeName, "'targetTypeName' must not be null");
        this.targetType = targetTypeName;
    }

    public String getTargetTypeName() {
        Object targetTypeValue = this.targetType;
        if (targetTypeValue instanceof Class) {
            return ((Class)targetTypeValue).getName();
        }
        return (String)targetTypeValue;
    }

    public boolean hasTargetType() {
        return this.targetType instanceof Class;
    }

    public Class<?> resolveTargetType(ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> resolvedClass;
        if (this.targetType == null) {
            return null;
        }
        this.targetType = resolvedClass = ClassUtils.forName(this.getTargetTypeName(), classLoader);
        return resolvedClass;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public void setSpecifiedTypeName(String specifiedTypeName) {
        this.specifiedTypeName = specifiedTypeName;
    }

    public String getSpecifiedTypeName() {
        return this.specifiedTypeName;
    }

    public void setDynamic() {
        this.dynamic = true;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypedStringValue)) {
            return false;
        }
        TypedStringValue otherValue = (TypedStringValue)other;
        return ObjectUtils.nullSafeEquals(this.value, otherValue.value) && ObjectUtils.nullSafeEquals(this.targetType, otherValue.targetType);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.value) * 29 + ObjectUtils.nullSafeHashCode(this.targetType);
    }

    public String toString() {
        return "TypedStringValue: value [" + this.value + "], target type [" + this.targetType + "]";
    }
}

