/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.beans.factory.config;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.qubership.profiler.shaded.org.springframework.beans.factory.FactoryBean;
import org.qubership.profiler.shaded.org.springframework.beans.factory.InitializingBean;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.YamlProcessor;

public class YamlMapFactoryBean
extends YamlProcessor
implements FactoryBean<Map<String, Object>>,
InitializingBean {
    private boolean singleton = true;
    private Map<String, Object> map;

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.isSingleton()) {
            this.map = this.createMap();
        }
    }

    @Override
    public Map<String, Object> getObject() {
        return this.map != null ? this.map : this.createMap();
    }

    @Override
    public Class<?> getObjectType() {
        return Map.class;
    }

    protected Map<String, Object> createMap() {
        final LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.process(new YamlProcessor.MatchCallback(){

            @Override
            public void process(Properties properties, Map<String, Object> map) {
                YamlMapFactoryBean.this.merge(result, map);
            }
        });
        return result;
    }

    private void merge(Map<String, Object> output, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Object existing = output.get(key);
            if (value instanceof Map && existing instanceof Map) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>((Map)existing);
                this.merge(result, (Map)value);
                output.put(key, result);
                continue;
            }
            output.put(key, value);
        }
    }
}

