/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.util.Locale;
import java.util.ResourceBundle;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

public class ResourceBundleEditor
extends PropertyEditorSupport {
    public static final String BASE_NAME_SEPARATOR = "_";

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        Assert.hasText(text, "'text' must not be empty");
        String name = text.trim();
        int separator = name.indexOf(BASE_NAME_SEPARATOR);
        if (separator == -1) {
            this.setValue(ResourceBundle.getBundle(name));
        } else {
            String baseName = name.substring(0, separator);
            if (!StringUtils.hasText(baseName)) {
                throw new IllegalArgumentException("Invalid ResourceBundle name: '" + text + "'");
            }
            String localeString = name.substring(separator + 1);
            Locale locale = StringUtils.parseLocaleString(localeString);
            this.setValue(StringUtils.hasText(localeString) ? ResourceBundle.getBundle(baseName, locale) : ResourceBundle.getBundle(baseName));
        }
    }
}

