/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot;

import java.lang.reflect.Method;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationListener;
import org.qubership.profiler.shaded.org.springframework.context.event.ContextRefreshedEvent;
import org.qubership.profiler.shaded.org.springframework.util.ReflectionUtils;

class ClearCachesApplicationListener
implements ApplicationListener<ContextRefreshedEvent> {
    ClearCachesApplicationListener() {
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        ReflectionUtils.clearCache();
        this.clearClassLoaderCaches(Thread.currentThread().getContextClassLoader());
    }

    private void clearClassLoaderCaches(ClassLoader classLoader) {
        if (classLoader == null) {
            return;
        }
        try {
            Method clearCacheMethod = classLoader.getClass().getDeclaredMethod("clearCache", new Class[0]);
            clearCacheMethod.invoke((Object)classLoader, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clearClassLoaderCaches(classLoader.getParent());
    }
}

