/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.concurrent.Callable;
import org.qubership.profiler.shaded.org.apache.commons.logging.Log;
import org.qubership.profiler.shaded.org.springframework.boot.ApplicationHome;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContext;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;
import org.qubership.profiler.shaded.org.springframework.util.StopWatch;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

class StartupInfoLogger {
    private final Class<?> sourceClass;

    StartupInfoLogger(Class<?> sourceClass) {
        this.sourceClass = sourceClass;
    }

    public void logStarting(Log log) {
        Assert.notNull(log, "Log must not be null");
        if (log.isInfoEnabled()) {
            log.info(this.getStartupMessage());
        }
        if (log.isDebugEnabled()) {
            log.debug(this.getRunningMessage());
        }
    }

    public void logStarted(Log log, StopWatch stopWatch) {
        if (log.isInfoEnabled()) {
            log.info(this.getStartedMessage(stopWatch));
        }
    }

    private String getStartupMessage() {
        StringBuilder message = new StringBuilder();
        message.append("Starting ");
        message.append(this.getApplicationName());
        message.append(this.getVersion(this.sourceClass));
        message.append(this.getOn());
        message.append(this.getPid());
        message.append(this.getContext());
        return message.toString();
    }

    private StringBuilder getRunningMessage() {
        StringBuilder message = new StringBuilder();
        message.append("Running with Spring Boot");
        message.append(this.getVersion(this.getClass()));
        message.append(", Spring");
        message.append(this.getVersion(ApplicationContext.class));
        return message;
    }

    private StringBuilder getStartedMessage(StopWatch stopWatch) {
        StringBuilder message = new StringBuilder();
        message.append("Started ");
        message.append(this.getApplicationName());
        message.append(" in ");
        message.append(stopWatch.getTotalTimeSeconds());
        try {
            double uptime = (double)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0;
            message.append(" seconds (JVM running for " + uptime + ")");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return message;
    }

    private String getApplicationName() {
        return this.sourceClass != null ? ClassUtils.getShortName(this.sourceClass) : "application";
    }

    private String getVersion(final Class<?> source) {
        return this.getValue(" v", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return source.getPackage().getImplementationVersion();
            }
        }, "");
    }

    private String getOn() {
        return this.getValue(" on ", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return InetAddress.getLocalHost().getHostName();
            }
        });
    }

    private String getPid() {
        return this.getValue(" with PID ", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return System.getProperty("PID");
            }
        });
    }

    private String getContext() {
        String path;
        String startedBy = this.getValue("started by ", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return System.getProperty("user.name");
            }
        });
        String in = this.getValue("in ", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return System.getProperty("user.dir");
            }
        });
        ApplicationHome home = new ApplicationHome(this.sourceClass);
        String string = path = home.getSource() == null ? "" : home.getSource().getAbsolutePath();
        if (startedBy == null && path == null) {
            return "";
        }
        if (StringUtils.hasLength(startedBy) && StringUtils.hasLength(path)) {
            startedBy = " " + startedBy;
        }
        if (StringUtils.hasLength(in) && StringUtils.hasLength(startedBy)) {
            in = " " + in;
        }
        return " (" + path + startedBy + in + ")";
    }

    private String getValue(String prefix, Callable<Object> call) {
        return this.getValue(prefix, call, "");
    }

    private String getValue(String prefix, Callable<Object> call, String defaultValue) {
        try {
            Object value = call.call();
            if (value != null && StringUtils.hasLength(value.toString())) {
                return prefix + value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }
}

