/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.amqp;

import org.qubership.profiler.shaded.org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.qubership.profiler.shaded.org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.qubership.profiler.shaded.org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.qubership.profiler.shaded.org.springframework.amqp.support.converter.MessageConverter;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ObjectProvider;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.amqp.SimpleRabbitListenerContainerFactoryConfigurer;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={EnableRabbit.class})
class RabbitAnnotationDrivenConfiguration {
    private final ObjectProvider<MessageConverter> messageConverter;
    private final RabbitProperties properties;

    RabbitAnnotationDrivenConfiguration(ObjectProvider<MessageConverter> messageConverter, RabbitProperties properties) {
        this.messageConverter = messageConverter;
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SimpleRabbitListenerContainerFactoryConfigurer rabbitListenerContainerFactoryConfigurer() {
        SimpleRabbitListenerContainerFactoryConfigurer configurer = new SimpleRabbitListenerContainerFactoryConfigurer();
        configurer.setMessageConverter(this.messageConverter.getIfUnique());
        configurer.setRabbitProperties(this.properties);
        return configurer;
    }

    @Bean
    @ConditionalOnMissingBean(name={"rabbitListenerContainerFactory"})
    public SimpleRabbitListenerContainerFactory rabbitListenerContainerFactory(SimpleRabbitListenerContainerFactoryConfigurer configurer, ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        configurer.configure(factory, connectionFactory);
        return factory;
    }

    @EnableRabbit
    @ConditionalOnMissingBean(name={"org.qubership.profiler.shaded.org.springframework.amqp.rabbit.config.internalRabbitListenerAnnotationProcessor"})
    protected static class EnableRabbitConfiguration {
        protected EnableRabbitConfiguration() {
        }
    }
}

