/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.amqp;

import org.qubership.profiler.shaded.org.aopalliance.aop.Advice;
import org.qubership.profiler.shaded.org.springframework.amqp.rabbit.config.RetryInterceptorBuilder;
import org.qubership.profiler.shaded.org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.qubership.profiler.shaded.org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.qubership.profiler.shaded.org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.qubership.profiler.shaded.org.springframework.amqp.rabbit.retry.RejectAndDontRequeueRecoverer;
import org.qubership.profiler.shaded.org.springframework.amqp.support.converter.MessageConverter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.qubership.profiler.shaded.org.springframework.util.Assert;

public final class SimpleRabbitListenerContainerFactoryConfigurer {
    private MessageConverter messageConverter;
    private RabbitProperties rabbitProperties;

    void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    void setRabbitProperties(RabbitProperties rabbitProperties) {
        this.rabbitProperties = rabbitProperties;
    }

    public void configure(SimpleRabbitListenerContainerFactory factory, ConnectionFactory connectionFactory) {
        RabbitProperties.ListenerRetry retryConfig;
        Assert.notNull(factory, "Factory must not be null");
        Assert.notNull(connectionFactory, "ConnectionFactory must not be null");
        factory.setConnectionFactory(connectionFactory);
        if (this.messageConverter != null) {
            factory.setMessageConverter(this.messageConverter);
        }
        RabbitProperties.Listener listenerConfig = this.rabbitProperties.getListener();
        factory.setAutoStartup(Boolean.valueOf(listenerConfig.isAutoStartup()));
        if (listenerConfig.getAcknowledgeMode() != null) {
            factory.setAcknowledgeMode(listenerConfig.getAcknowledgeMode());
        }
        if (listenerConfig.getConcurrency() != null) {
            factory.setConcurrentConsumers(listenerConfig.getConcurrency());
        }
        if (listenerConfig.getMaxConcurrency() != null) {
            factory.setMaxConcurrentConsumers(listenerConfig.getMaxConcurrency());
        }
        if (listenerConfig.getPrefetch() != null) {
            factory.setPrefetchCount(listenerConfig.getPrefetch());
        }
        if (listenerConfig.getTransactionSize() != null) {
            factory.setTxSize(listenerConfig.getTransactionSize());
        }
        if (listenerConfig.getDefaultRequeueRejected() != null) {
            factory.setDefaultRequeueRejected(listenerConfig.getDefaultRequeueRejected());
        }
        if (listenerConfig.getIdleEventInterval() != null) {
            factory.setIdleEventInterval(listenerConfig.getIdleEventInterval());
        }
        if ((retryConfig = listenerConfig.getRetry()).isEnabled()) {
            RetryInterceptorBuilder.StatelessRetryInterceptorBuilder builder = retryConfig.isStateless() ? RetryInterceptorBuilder.stateless() : RetryInterceptorBuilder.stateful();
            builder.maxAttempts(retryConfig.getMaxAttempts());
            builder.backOffOptions(retryConfig.getInitialInterval(), retryConfig.getMultiplier(), retryConfig.getMaxInterval());
            builder.recoverer((MessageRecoverer)new RejectAndDontRequeueRecoverer());
            factory.setAdviceChain(new Advice[]{builder.build()});
        }
    }
}

