/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.batch;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.qubership.profiler.shaded.org.springframework.batch.core.configuration.ListableJobLocator;
import org.qubership.profiler.shaded.org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.qubership.profiler.shaded.org.springframework.batch.core.converter.JobParametersConverter;
import org.qubership.profiler.shaded.org.springframework.batch.core.explore.JobExplorer;
import org.qubership.profiler.shaded.org.springframework.batch.core.explore.support.JobExplorerFactoryBean;
import org.qubership.profiler.shaded.org.springframework.batch.core.launch.JobLauncher;
import org.qubership.profiler.shaded.org.springframework.batch.core.launch.JobOperator;
import org.qubership.profiler.shaded.org.springframework.batch.core.launch.support.SimpleJobOperator;
import org.qubership.profiler.shaded.org.springframework.batch.core.repository.JobRepository;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ObjectProvider;
import org.qubership.profiler.shaded.org.springframework.boot.ExitCodeGenerator;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.batch.BasicBatchConfigurer;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.batch.BatchDatabaseInitializer;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.batch.JobExecutionExitCodeGenerator;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.batch.JobLauncherCommandLineRunner;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.core.io.ResourceLoader;
import org.qubership.profiler.shaded.org.springframework.jdbc.core.JdbcOperations;
import org.qubership.profiler.shaded.org.springframework.transaction.PlatformTransactionManager;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={JobLauncher.class, DataSource.class, JdbcOperations.class})
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class})
@ConditionalOnBean(value={JobLauncher.class})
@EnableConfigurationProperties(value={BatchProperties.class})
public class BatchAutoConfiguration {
    private final BatchProperties properties;
    private final JobParametersConverter jobParametersConverter;

    public BatchAutoConfiguration(BatchProperties properties, ObjectProvider<JobParametersConverter> jobParametersConverter) {
        this.properties = properties;
        this.jobParametersConverter = jobParametersConverter.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={DataSource.class})
    public BatchDatabaseInitializer batchDatabaseInitializer(DataSource dataSource, ResourceLoader resourceLoader) {
        return new BatchDatabaseInitializer(dataSource, resourceLoader, this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.batch.job", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public JobLauncherCommandLineRunner jobLauncherCommandLineRunner(JobLauncher jobLauncher, JobExplorer jobExplorer) {
        JobLauncherCommandLineRunner runner = new JobLauncherCommandLineRunner(jobLauncher, jobExplorer);
        String jobNames = this.properties.getJob().getNames();
        if (StringUtils.hasText(jobNames)) {
            runner.setJobNames(jobNames);
        }
        return runner;
    }

    @Bean
    @ConditionalOnMissingBean(value={ExitCodeGenerator.class})
    public JobExecutionExitCodeGenerator jobExecutionExitCodeGenerator() {
        return new JobExecutionExitCodeGenerator();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={DataSource.class})
    public JobExplorer jobExplorer(DataSource dataSource) throws Exception {
        JobExplorerFactoryBean factory = new JobExplorerFactoryBean();
        factory.setDataSource(dataSource);
        String tablePrefix = this.properties.getTablePrefix();
        if (StringUtils.hasText(tablePrefix)) {
            factory.setTablePrefix(tablePrefix);
        }
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    @Bean
    @ConditionalOnMissingBean(value={JobOperator.class})
    public SimpleJobOperator jobOperator(JobExplorer jobExplorer, JobLauncher jobLauncher, ListableJobLocator jobRegistry, JobRepository jobRepository) throws Exception {
        SimpleJobOperator factory = new SimpleJobOperator();
        factory.setJobExplorer(jobExplorer);
        factory.setJobLauncher(jobLauncher);
        factory.setJobRegistry(jobRegistry);
        factory.setJobRepository(jobRepository);
        if (this.jobParametersConverter != null) {
            factory.setJobParametersConverter(this.jobParametersConverter);
        }
        return factory;
    }

    @EnableConfigurationProperties(value={BatchProperties.class})
    @ConditionalOnClass(value={PlatformTransactionManager.class}, name={"javax.persistence.EntityManagerFactory"})
    @ConditionalOnMissingBean(value={BatchConfigurer.class})
    @Configuration
    protected static class JpaBatchConfiguration {
        private final BatchProperties properties;

        protected JpaBatchConfiguration(BatchProperties properties) {
            this.properties = properties;
        }

        @Bean
        @ConditionalOnBean(name={"entityManagerFactory"})
        public BasicBatchConfigurer jpaBatchConfigurer(DataSource dataSource, EntityManagerFactory entityManagerFactory, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
            return new BasicBatchConfigurer(this.properties, dataSource, entityManagerFactory, transactionManagerCustomizers.getIfAvailable());
        }

        @Bean
        @ConditionalOnMissingBean(name={"entityManagerFactory"})
        public BasicBatchConfigurer basicBatchConfigurer(DataSource dataSource, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
            return new BasicBatchConfigurer(this.properties, dataSource, transactionManagerCustomizers.getIfAvailable());
        }
    }
}

