/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache;

import java.util.List;
import javax.annotation.PostConstruct;
import org.qubership.profiler.shaded.org.springframework.beans.BeansException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ObjectProvider;
import org.qubership.profiler.shaded.org.springframework.beans.factory.annotation.Autowired;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanDefinition;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache.CacheConfigurations;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache.CacheManagerCustomizer;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache.CacheManagerCustomizers;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache.CacheType;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.couchbase.CouchbaseAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.data.jpa.EntityManagerFactoryDependsOnPostProcessor;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.hazelcast.HazelcastAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.cache.CacheManager;
import org.qubership.profiler.shaded.org.springframework.cache.interceptor.CacheAspectSupport;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Import;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ImportSelector;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Role;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotationMetadata;
import org.qubership.profiler.shaded.org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.qubership.profiler.shaded.org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.qubership.profiler.shaded.org.springframework.util.Assert;

@Configuration
@ConditionalOnClass(value={CacheManager.class})
@ConditionalOnBean(value={CacheAspectSupport.class})
@ConditionalOnMissingBean(value={CacheManager.class}, name={"cacheResolver"})
@EnableConfigurationProperties(value={CacheProperties.class})
@AutoConfigureBefore(value={HibernateJpaAutoConfiguration.class})
@AutoConfigureAfter(value={CouchbaseAutoConfiguration.class, HazelcastAutoConfiguration.class, RedisAutoConfiguration.class})
@Import(value={CacheConfigurationImportSelector.class})
public class CacheAutoConfiguration {
    static final String VALIDATOR_BEAN_NAME = "cacheAutoConfigurationValidator";

    @Bean
    @ConditionalOnMissingBean
    public CacheManagerCustomizers cacheManagerCustomizers(ObjectProvider<List<CacheManagerCustomizer<?>>> customizers) {
        return new CacheManagerCustomizers(customizers.getIfAvailable());
    }

    @Bean
    @Role(value=2)
    public static CacheManagerValidatorPostProcessor cacheAutoConfigurationValidatorPostProcessor() {
        return new CacheManagerValidatorPostProcessor();
    }

    @Bean(name={"cacheAutoConfigurationValidator"})
    public CacheManagerValidator cacheAutoConfigurationValidator() {
        return new CacheManagerValidator();
    }

    static class CacheConfigurationImportSelector
    implements ImportSelector {
        CacheConfigurationImportSelector() {
        }

        @Override
        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            CacheType[] types = CacheType.values();
            String[] imports = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                imports[i] = CacheConfigurations.getConfigurationClass(types[i]);
            }
            return imports;
        }
    }

    static class CacheManagerValidator {
        @Autowired
        private CacheProperties cacheProperties;
        @Autowired(required=false)
        private CacheManager cacheManager;

        CacheManagerValidator() {
        }

        @PostConstruct
        public void checkHasCacheManager() {
            Assert.notNull(this.cacheManager, "No cache manager could be auto-configured, check your configuration (caching type is '" + (Object)((Object)this.cacheProperties.getType()) + "')");
        }
    }

    static class CacheManagerValidatorPostProcessor
    implements BeanFactoryPostProcessor {
        CacheManagerValidatorPostProcessor() {
        }

        @Override
        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            for (String name : beanFactory.getBeanNamesForType(CacheAspectSupport.class, false, false)) {
                BeanDefinition definition = beanFactory.getBeanDefinition(name);
                definition.setDependsOn(this.append(definition.getDependsOn(), CacheAutoConfiguration.VALIDATOR_BEAN_NAME));
            }
        }

        private String[] append(String[] array, String value) {
            String[] result = new String[array == null ? 1 : array.length + 1];
            if (array != null) {
                System.arraycopy(array, 0, result, 0, array.length);
            }
            result[result.length - 1] = value;
            return result;
        }
    }

    @Configuration
    @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
    @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
    protected static class CacheManagerJpaDependencyConfiguration
    extends EntityManagerFactoryDependsOnPostProcessor {
        public CacheManagerJpaDependencyConfiguration() {
            super("cacheManager");
        }
    }
}

