/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.qubership.profiler.shaded.org.apache.commons.logging.Log;
import org.qubership.profiler.shaded.org.apache.commons.logging.LogFactory;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache.CacheManagerCustomizer;
import org.qubership.profiler.shaded.org.springframework.cache.CacheManager;
import org.qubership.profiler.shaded.org.springframework.core.ResolvableType;

public class CacheManagerCustomizers {
    private static final Log logger = LogFactory.getLog(CacheManagerCustomizers.class);
    private final List<CacheManagerCustomizer<?>> customizers;

    public CacheManagerCustomizers(List<? extends CacheManagerCustomizer<?>> customizers) {
        this.customizers = customizers != null ? new ArrayList(customizers) : Collections.emptyList();
    }

    public <T extends CacheManager> T customize(T cacheManager) {
        for (CacheManagerCustomizer<?> customizer : this.customizers) {
            Class<?> generic = ResolvableType.forClass(CacheManagerCustomizer.class, customizer.getClass()).resolveGeneric(new int[0]);
            if (!generic.isInstance(cacheManager)) continue;
            this.customize(cacheManager, customizer);
        }
        return cacheManager;
    }

    private void customize(CacheManager cacheManager, CacheManagerCustomizer customizer) {
        block2: {
            try {
                customizer.customize(cacheManager);
            }
            catch (ClassCastException ex) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Non-matching cache manager type for customizer: " + customizer, ex);
            }
        }
    }
}

