/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache.CacheCondition;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache.CacheManagerCustomizers;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ResourceCondition;
import org.qubership.profiler.shaded.org.springframework.cache.ehcache.EhCacheCacheManager;
import org.qubership.profiler.shaded.org.springframework.cache.ehcache.EhCacheManagerUtils;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Conditional;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.core.io.Resource;

@Configuration
@ConditionalOnClass(value={Cache.class, EhCacheCacheManager.class})
@ConditionalOnMissingBean(value={org.qubership.profiler.shaded.org.springframework.cache.CacheManager.class})
@Conditional(value={CacheCondition.class, ConfigAvailableCondition.class})
class EhCacheCacheConfiguration {
    private final CacheProperties cacheProperties;
    private final CacheManagerCustomizers customizers;

    EhCacheCacheConfiguration(CacheProperties cacheProperties, CacheManagerCustomizers customizers) {
        this.cacheProperties = cacheProperties;
        this.customizers = customizers;
    }

    @Bean
    public EhCacheCacheManager cacheManager(CacheManager ehCacheCacheManager) {
        return this.customizers.customize(new EhCacheCacheManager(ehCacheCacheManager));
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheManager ehCacheCacheManager() {
        Resource location = this.cacheProperties.resolveConfigLocation(this.cacheProperties.getEhcache().getConfig());
        if (location != null) {
            return EhCacheManagerUtils.buildCacheManager((Resource)location);
        }
        return EhCacheManagerUtils.buildCacheManager();
    }

    static class ConfigAvailableCondition
    extends ResourceCondition {
        ConfigAvailableCondition() {
            super("EhCache", "spring.cache.ehcache", "config", "classpath:/ehcache.xml");
        }
    }
}

