/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition;

import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanExpressionContext;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanExpressionResolver;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConditionContext;
import org.qubership.profiler.shaded.org.springframework.context.expression.StandardBeanExpressionResolver;
import org.qubership.profiler.shaded.org.springframework.core.annotation.Order;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotatedTypeMetadata;

@Order(value=2147483627)
class OnExpressionCondition
extends SpringBootCondition {
    OnExpressionCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        BeanExpressionContext expressionContext;
        String expression = (String)metadata.getAnnotationAttributes(ConditionalOnExpression.class.getName()).get("value");
        String rawExpression = expression = this.wrapIfNecessary(expression);
        expression = context.getEnvironment().resolvePlaceholders(expression);
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        BeanExpressionResolver resolver = beanFactory != null ? beanFactory.getBeanExpressionResolver() : null;
        BeanExpressionContext beanExpressionContext = expressionContext = beanFactory != null ? new BeanExpressionContext(beanFactory, null) : null;
        if (resolver == null) {
            resolver = new StandardBeanExpressionResolver();
        }
        boolean result = (Boolean)resolver.evaluate(expression, expressionContext);
        return new ConditionOutcome(result, ConditionMessage.forCondition(ConditionalOnExpression.class, "(" + rawExpression + ")").resultedIn(result));
    }

    private String wrapIfNecessary(String expression) {
        if (!expression.startsWith("#{")) {
            return "#{" + expression + "}";
        }
        return expression;
    }
}

